/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.tools;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.ariane.tools.InputDataset;
import org.ariane.tools.ResourcesException;
import org.ariane.tools.ToolBox;

public class Resources {
    public static final String JVS_HOME = "jvs.home";
    private Properties prop;
    private String libdir;
    protected static Resources resources = null;

    public static Resources instance() {
        if (resources == null) {
            resources = new Resources();
        }
        return resources;
    }

    protected Resources() {
        try {
            this.setUpProperties();
        }
        catch (Exception exception) {
            ToolBox.warn("Can't set up properties", exception);
        }
    }

    private final void setUpProperties() {
        this.prop = new Properties();
        ((Hashtable)this.prop).put("Software", "ariane");
        this.getJVSHome();
    }

    public void load() {
        this.load(null);
    }

    public void load(String string) {
        try {
            String string2;
            File file;
            this.read(this.getLibDirectory() + "jvs.properties");
            if (string != null) {
                this.read(this.getLibDirectory() + string);
            }
            if ((file = new File(string2 = this.getUserHomeDirectory() + ".jvs.properties")).exists()) {
                this.read(string2);
            }
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't read properties ", iOException);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't load properties ", exception);
        }
    }

    private final void read(String string) throws IOException {
        if (ToolBox.debug) {
            ToolBox.warn("Reading " + string);
        }
        InputDataset inputDataset = new InputDataset(string);
        this.prop.load(inputDataset.getStream());
        inputDataset.close();
    }

    public final String getUserHomeDirectory() {
        try {
            String string = System.getProperty("file.separator");
            String string2 = System.getProperty("user.home");
            String string3 = string2 + string;
            return string3;
        }
        catch (Exception exception) {
            System.err.println("Can't get user home directory !");
            System.err.println("Exception caught : " + exception + " !");
            return null;
        }
    }

    private final String getUserLibDirectory() {
        try {
            String string = System.getProperty("file.separator");
            String string2 = System.getProperty("user.home");
            String string3 = string2 + string + "lib" + string;
            File file = new File(string3);
            if (file.isDirectory()) {
                return string3;
            }
        }
        catch (Exception exception) {
            System.err.println("Can't get user lib directory !");
            System.err.println("Exception caught : " + exception + " !");
            return null;
        }
        return null;
    }

    private final void setLibDirectory() {
        String string = System.getProperty("file.separator");
        this.setLibDirectory(this.getJVSHome() + string + "lib");
    }

    private final void setLibDirectory(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null lib directory");
        }
        this.libdir = string;
        String string2 = "/";
        try {
            if (!string.startsWith("http:")) {
                string2 = System.getProperty("file.separator");
            }
        }
        catch (Exception exception) {
            System.err.println("Exception caught : " + exception + " !");
        }
        char c = this.libdir.charAt(this.libdir.length() - 1);
        if (c != '\\' && c != '/') {
            this.libdir = this.libdir + string2;
        }
    }

    public final String getLibDirectory() {
        if (this.libdir == null) {
            this.setLibDirectory();
        }
        return this.libdir;
    }

    public final String getBinDirectory() {
        String string = this.getLibDirectory();
        int n = string.length() - 4;
        return string.substring(0, n) + "bin" + System.getProperty("file.separator");
    }

    public final Properties getProperties() {
        return this.prop;
    }

    public void saveProperties() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("Properties");
            this.prop.store(fileOutputStream, " Ariane Resources");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Exception caught : " + iOException + " !");
        }
    }

    public String getPropertyValues() {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.prop.list(printWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void dump() {
        try {
            ToolBox.warn("Dumping resources " + this.getLibDirectory());
            this.prop.list(System.out);
        }
        catch (Exception exception) {
            ToolBox.warn("Resources Dump", exception);
        }
    }

    public final void setJVSHome(String string) {
        ((Hashtable)this.prop).put(JVS_HOME, string);
    }

    public final String getJVSHome() {
        String string = this.prop.getProperty(JVS_HOME);
        if (string != null) {
            return string;
        }
        string = System.getProperty(JVS_HOME);
        if (string != null) {
            this.setJVSHome(string);
            return string;
        }
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf("jvs.jar") - 4;
            if (n < 0) continue;
            string = n == 0 ? "." : string4.substring(0, n - 1);
            this.setJVSHome(string);
            return string;
        }
        if (ToolBox.debug) {
            ToolBox.warn("java.class.path " + string2);
            ToolBox.warn("path.separator " + string3);
        }
        throw new ResourcesException("Can't find JVS home directory");
    }

    public final void copyFromSystem(String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            ((Hashtable)this.prop).put(string, string2);
        }
    }

    public final void copyToSystem(String string) {
        String string2 = this.prop.getProperty(string);
        if (string2 != null) {
            System.setProperty(string, string2);
        }
    }

    public final void put(String string, String string2) {
        ((Hashtable)this.prop).put(string, string2);
    }

    public final String get(String string) {
        return this.prop.getProperty(string);
    }

    public final String get(String string, String string2) {
        return this.prop.getProperty(string, string2);
    }

    public final String getImagePath(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.getLibDirectory());
        stringBuffer.append("images");
        stringBuffer.append(System.getProperty("file.separator"));
        stringBuffer.append(this.get(string, "unknown.gif"));
        return stringBuffer.toString();
    }

    public final boolean get(String string, boolean bl) {
        String string2 = this.prop.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equalsIgnoreCase("true");
    }

    public final int get(String string, int n) {
        int n2;
        String string2 = this.prop.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
        return n2;
    }

    public final float get(String string, float f) {
        Float f2;
        String string2 = this.prop.getProperty(string);
        if (string2 == null) {
            return f;
        }
        try {
            f2 = Float.valueOf(string2);
        }
        catch (Exception exception) {
            return f;
        }
        return f2.floatValue();
    }

    public final Font get(String string, String string2, int n, int n2) {
        String string3 = this.prop.getProperty(string);
        if (string3 == null) {
            return new Font(string2, n, n2);
        }
        String string4 = "Times";
        int n3 = 0;
        int n4 = 16;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
        string4 = stringTokenizer.nextToken().trim();
        String string5 = stringTokenizer.nextToken().trim();
        if (string5.equalsIgnoreCase("P")) {
            n3 = 0;
        } else if (string5.equalsIgnoreCase("R")) {
            n3 = 0;
        } else if (string5.equalsIgnoreCase("I")) {
            n3 = 2;
        } else if (string5.equalsIgnoreCase("B")) {
            n3 = 1;
        }
        string5 = stringTokenizer.nextToken().trim();
        try {
            n4 = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Font(string4, n3, n4);
    }

    public final Color get(String string, Color color) {
        String string2 = this.prop.getProperty(string);
        if (string2 == null) {
            return color;
        }
        if (string2.indexOf(35) == 0) {
            try {
                return new Color(Integer.parseInt(string2.substring(1), 16));
            }
            catch (Exception exception) {
                ToolBox.warn("Can't parse " + string, exception);
                return color;
            }
        }
        if (string2.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string2.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string2.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string2.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string2.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string2.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string2.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string2.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string2.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string2.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string2.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string2.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string2.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        return color;
    }
}

