/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.tools;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;

public class PlainList
extends AbstractList
implements Serializable {
    protected Object[] list;
    private int nbr;
    private static final int INITIAL_CAPACITY = 100;
    private static final int CAPACITY_INCREMENT = 100;

    public PlainList(int n) {
        this.list = new Object[n];
        this.nbr = 0;
    }

    public PlainList() {
        this(100);
    }

    public PlainList(Enumeration enumeration) {
        this();
        this.set(enumeration);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("PlainList : ");
        stringBuffer.append(" [");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" ").append(String.valueOf(iterator.next()));
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public final synchronized boolean add(Object object) {
        if (this.size() >= this.capacity()) {
            this.enlarge();
        }
        this.list[this.nbr++] = object;
        return true;
    }

    public final Object get(int n) {
        return this.list[n];
    }

    public final int size() {
        return this.nbr;
    }

    public final void set(Enumeration enumeration) {
        int n = 0;
        while (enumeration.hasMoreElements()) {
            this.add(enumeration.nextElement());
            ++n;
        }
    }

    public final int capacity() {
        return this.list.length;
    }

    private final synchronized void enlarge() {
        Object[] objectArray = new Object[this.capacity() + 100];
        int n = 0;
        while (n < this.size()) {
            objectArray[n] = this.list[n];
            ++n;
        }
        this.list = objectArray;
    }
}

