/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.tools;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.ariane.tools.Nameable;
import org.ariane.tools.Nobject;
import org.ariane.tools.OutputDataset;
import org.ariane.tools.ToolBox;

public class NobjSet
extends Nobject {
    protected Vector table = new Vector(50, 10);

    public NobjSet(String string) {
        super(string);
    }

    public static NobjSet readSerial(String string) {
        NobjSet nobjSet;
        if (ToolBox.verbose) {
            ToolBox.warn("Reading serial " + string + " ...");
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            nobjSet = (NobjSet)objectInputStream.readObject();
            fileInputStream.close();
        }
        catch (Exception exception) {
            ToolBox.warn("Can't read file " + string);
            ToolBox.warn("Exception caught", exception);
            return null;
        }
        return nobjSet;
    }

    public boolean write(String string) {
        if (ToolBox.verbose) {
            System.out.println("Writing " + this.getName() + " to " + string + " !");
        }
        OutputDataset outputDataset = new OutputDataset(string);
        int n = this.getNameMaxLength();
        try {
            outputDataset.open();
            outputDataset.writeHeader(this.getName());
            Iterator iterator = ((AbstractList)this.table).iterator();
            while (iterator.hasNext()) {
                Nameable nameable = (Nameable)iterator.next();
                String string2 = nameable.toString();
                outputDataset.writeLine(string2);
            }
            outputDataset.writeFooter();
        }
        catch (Exception exception) {
            System.err.println("Can't write file " + outputDataset.getName() + " !");
            System.err.println("Exception caught : " + exception + " !");
            return false;
        }
        return true;
    }

    public boolean writeSerial(String string) {
        try {
            if (ToolBox.verbose) {
                ToolBox.warn("Writing " + this.size() + " sites to serial " + string + " ...");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            ToolBox.warn("Can't write file " + string);
            ToolBox.warn("Exception caught", exception);
            return false;
        }
        return true;
    }

    private final int getNameMaxLength() {
        int n = 0;
        Iterator iterator = ((AbstractList)this.table).iterator();
        while (iterator.hasNext()) {
            Nameable nameable = (Nameable)iterator.next();
            int n2 = nameable.getName().length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public final synchronized Iterator iterator() {
        return ((AbstractList)this.table).iterator();
    }

    public final synchronized void trimToSize() {
        this.table.trimToSize();
    }

    public final int size() {
        return this.table.size();
    }

    public final String[] namesArray() {
        String[] stringArray = new String[this.table.size()];
        int n = 0;
        Iterator iterator = ((AbstractList)this.table).iterator();
        while (iterator.hasNext()) {
            Nameable nameable = (Nameable)iterator.next();
            stringArray[n++] = new String(nameable.getName());
        }
        return stringArray;
    }

    public final void sort() {
        int n;
        int n2 = this.table.size();
        Object[] objectArray = new Nobject[n2];
        this.table.copyInto(objectArray);
        this.table.removeAllElements();
        int n3 = n2 - 2;
        while (n3 >= 0) {
            int n4;
            Object object;
            n = n3 + 1;
            while (n < n2) {
                if (((Nobject)objectArray[n3]).compareTo((Nobject)objectArray[n]) > 0) {
                    object = objectArray[n3];
                    n4 = n3 + 1;
                    while (n4 < n) {
                        objectArray[n4 - 1] = objectArray[n4];
                        ++n4;
                    }
                    objectArray[n - 1] = object;
                    break;
                }
                ++n;
            }
            if (n == n2) {
                object = objectArray[n3];
                n4 = n3 + 1;
                while (n4 < n2) {
                    objectArray[n4 - 1] = objectArray[n4];
                    ++n4;
                }
                objectArray[n2 - 1] = object;
            }
            --n3;
        }
        n = 0;
        while (n < n2) {
            this.table.addElement(objectArray[n]);
            ++n;
        }
    }

    public final void add(Nameable nameable) {
        this.table.add(nameable);
    }

    public final Nameable get(String string) {
        Nobject nobject = new Nobject(string);
        int n = this.table.indexOf(nobject);
        if (n < 0) {
            return null;
        }
        return (Nameable)this.table.elementAt(n);
    }

    public final Nameable get(int n) {
        return (Nameable)this.table.elementAt(n);
    }

    public final Nameable getFirst() {
        return (Nameable)this.table.elementAt(0);
    }

    public final Nameable getLast() {
        return (Nameable)this.table.elementAt(this.table.size() - 1);
    }

    public final Nameable getForward(Nameable nameable) {
        int n = this.table.indexOf(nameable);
        if (n < 0) {
            throw new NoSuchElementException(nameable.getName());
        }
        if (++n >= this.table.size()) {
            n = 0;
        }
        return (Nameable)this.table.elementAt(n);
    }

    public final Nameable getBackward(Nameable nameable) {
        int n = this.table.indexOf(nameable);
        if (n < 0) {
            throw new NoSuchElementException(nameable.getName());
        }
        if (--n < 0) {
            n = this.table.size() - 1;
        }
        return (Nameable)this.table.elementAt(n);
    }

    public final int indexOf(String string) {
        Nobject nobject = new Nobject(string);
        return this.table.indexOf(nobject);
    }

    public final int indexOf(Nobject nobject) {
        return this.table.indexOf(nobject);
    }

    public void dump() {
        System.out.println("Set : " + this.getName() + " size : " + this.table.size() + " (" + this.table.capacity() + ") objects !");
        Iterator iterator = ((AbstractList)this.table).iterator();
        while (iterator.hasNext()) {
            Nameable nameable = (Nameable)iterator.next();
            System.out.println(nameable.toString());
        }
        System.out.println();
    }
}

