/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.tools;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;

public class MiniSet
extends AbstractList
implements Serializable {
    static final long serialVersionUID = -3453650378541511920L;
    protected Object[] set;
    private int nbr;
    private static final int INITIAL_CAPACITY = 1;
    private static final int CAPACITY_INCREMENT = 1;

    public MiniSet(int n) {
        this.set = new Object[n];
        this.nbr = 0;
    }

    public MiniSet() {
        this(1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" ").append(String.valueOf(iterator.next()));
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public final synchronized boolean add(Object object) {
        if (this.contains(object)) {
            return false;
        }
        if (this.size() >= this.capacity()) {
            this.enlarge();
        }
        this.set[this.nbr++] = object;
        return true;
    }

    public final synchronized Object remove(int n) {
        Object object = this.set[n];
        int n2 = n + 1;
        while (n2 < this.nbr) {
            this.set[n2 - 1] = this.set[n2];
            ++n2;
        }
        this.set[this.nbr - 1] = null;
        --this.nbr;
        return object;
    }

    public final Object get(int n) {
        return this.set[n];
    }

    public final int size() {
        return this.nbr;
    }

    public final int capacity() {
        return this.set.length;
    }

    private final synchronized void enlarge() {
        Object[] objectArray = new Object[this.capacity() + 1];
        int n = 0;
        while (n < this.size()) {
            objectArray[n] = this.set[n];
            ++n;
        }
        this.set = objectArray;
    }

    public final synchronized Iterator iterator() {
        return new MiniIterator();
    }

    public void dump() {
        System.out.println(this.toString());
        System.out.println();
    }

    private class MiniIterator
    implements Iterator {
        transient int index;
        transient int last_index;

        public MiniIterator() {
            this.last_index = MiniSet.this.size() - 1;
            this.index = 0;
        }

        public final Object next() {
            return MiniSet.this.set[this.index++];
        }

        public final boolean hasNext() {
            return this.index <= this.last_index;
        }

        public void remove() {
            int n = this.index;
            while (n < MiniSet.this.nbr) {
                MiniSet.this.set[n - 1] = MiniSet.this.set[n];
                ++n;
            }
            --this.index;
            MiniSet.this.set[((MiniSet)MiniSet.this).nbr - 1] = null;
            MiniSet.this.nbr--;
        }
    }
}

