/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.tools;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.ariane.tools.BufferReader;
import org.ariane.tools.LinesReader;
import org.ariane.tools.Nobject;
import org.ariane.tools.SharedReader;
import org.ariane.tools.StreamReader;
import org.ariane.tools.ToolBox;

public final class InputDataset
extends Nobject {
    protected DataInputStream input = null;
    private boolean isurl;
    private LinesReader reader = null;
    private long modif;
    public static final int RAW = 0;
    public static final int BUFFER = 1;
    public static final int SHARED = 2;

    public InputDataset(String string) {
        super(string);
        this.isurl = string.indexOf("://") >= 0;
    }

    public final void open() throws IOException {
        this.createReader();
    }

    protected final void openStream() throws IOException {
        if (this.isurl) {
            this.openURL();
        } else {
            this.openFile();
        }
    }

    public boolean isModified() {
        long l;
        try {
            if (this.isurl) {
                URL uRL = new URL(this.getName());
                URLConnection uRLConnection = uRL.openConnection();
                l = uRLConnection.getLastModified();
            } else {
                File file = new File(this.getName());
                l = file.lastModified();
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't check dataset", exception);
            return true;
        }
        return l > this.modif;
    }

    private void openFile() throws IOException {
        File file = new File(this.getName());
        this.modif = file.lastModified();
        FileInputStream fileInputStream = new FileInputStream(file.getPath());
        this.input = new DataInputStream(fileInputStream);
    }

    private void openURL() throws IOException {
        URL uRL = new URL(this.getName());
        URLConnection uRLConnection = uRL.openConnection();
        this.modif = uRLConnection.getLastModified();
        this.input = new DataInputStream(uRLConnection.getInputStream());
    }

    public static Object getSource(String string) {
        if (string.indexOf("://") >= 0) {
            try {
                return new URL(string);
            }
            catch (Exception exception) {
                System.err.println("Invalid url " + string + " !");
                return null;
            }
        }
        return string;
    }

    public LinesReader createReader(int n) throws IOException {
        this.openStream();
        switch (n) {
            case 1: {
                this.reader = new BufferReader(this);
                break;
            }
            case 2: {
                this.reader = new SharedReader();
                break;
            }
            default: {
                this.reader = new StreamReader(this);
            }
        }
        return this.reader;
    }

    public final StreamReader createReader() throws IOException {
        return (StreamReader)this.createReader(0);
    }

    public final void close() throws IOException {
        this.input.close();
        this.input = null;
    }

    public final DataInputStream getStream() throws IOException {
        if (this.input == null) {
            this.open();
        }
        return this.input;
    }

    public final String getNextLine() {
        return this.reader.nextLine();
    }

    public final int lineNumber() {
        return this.reader.lineNumber();
    }

    public void dump() {
        System.out.println("Dumping InputDataset named : " + this.getName() + " !");
        File file = new File(this.getName());
        if (!file.exists()) {
            System.out.println("File does not exist !");
            return;
        }
        System.out.print("Path : ");
        System.out.println(file.getAbsolutePath());
    }
}

