/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.ariane.time.Calendar;
import org.ariane.tools.ToolBox;

public final class Hour
implements Cloneable {
    private static String sep = ":";
    private static TimeZone TZ = Calendar.LTZ;
    private Date when = null;

    public Hour() {
        this(Hour.toString(new Date()));
    }

    public Hour(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H:mm");
            simpleDateFormat.setTimeZone(TZ);
            this.when = simpleDateFormat.parse(string.trim());
        }
        catch (ParseException parseException) {
            ToolBox.warn("Can't parse Hour " + string, parseException);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't create Hour " + string, exception);
        }
    }

    public Object clone() {
        try {
            Hour hour = (Hour)super.clone();
            hour.when = new Date();
            hour.when.setTime(this.when.getTime());
            return hour;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private static String toString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        simpleDateFormat.setTimeZone(TZ);
        return simpleDateFormat.format(date);
    }

    public String toString() {
        return Hour.toString(this.when);
    }

    public final long getTime() {
        return this.when.getTime();
    }

    public final void addMinutes(int n) {
        Calendar calendar = new Calendar();
        calendar.setCurrentTime(this.when);
        calendar.add(12, n);
        this.when = calendar.getCurrentTime();
    }

    public final boolean before(Hour hour) {
        return this.when.before(hour.when);
    }

    public final boolean after(Hour hour) {
        return this.when.after(hour.when);
    }
}

