/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.time;

import java.util.Date;
import org.ariane.time.Calendar;

public abstract class DatedData {
    protected Date date;

    public DatedData() {
        this(new Date());
    }

    public DatedData(Date date) {
        this.date = date;
    }

    public final Date getDate() {
        return this.date;
    }

    public final long getTime() {
        return this.date.getTime();
    }

    public final Calendar getCalendar() {
        return Calendar.getUTCCalendar(this.date);
    }

    public abstract Date getNextDate();

    public abstract Date getPreviousDate();

    public String toString() {
        return this.date.toString();
    }

    public final boolean after(DatedData datedData) {
        return this.date.after(datedData.date);
    }

    public final boolean before(DatedData datedData) {
        return this.date.before(datedData.date);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DatedData)) {
            return false;
        }
        return this.date.equals(((DatedData)object).date);
    }
}

