/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.time;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public final class Calendar
extends GregorianCalendar {
    public static TimeZone LTZ = TimeZone.getTimeZone("GMT");
    public static TimeZone UTC = new SimpleTimeZone(0, "UTC");
    private static final int[] days_nbr = new int[]{31, 27, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final String[] month_name = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final long DAY_MS = 86400000L;

    public Calendar() {
        ((java.util.Calendar)this).setTimeZone(LTZ);
        this.computeFields();
    }

    public Calendar(Date date) {
        this();
        this.setCurrentTime(date);
    }

    public static Calendar getUTCCalendar(Date date) {
        Calendar calendar = new Calendar();
        ((java.util.Calendar)calendar).setTimeZone(UTC);
        calendar.setCurrentTime(date);
        return calendar;
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        simpleDateFormat.setTimeZone(LTZ);
        return simpleDateFormat.format(this.getTime());
    }

    public final int getMonthNumberOfDays() {
        int n = this.get(2);
        int n2 = days_nbr[n];
        if (n == 1 && this.isLeapYear(this.get(1))) {
            n2 = 28;
        }
        return n2;
    }

    public final void setDayInMonth(int n) {
        if (n < this.getMinimum(5) || n > this.getMaximum(5)) {
            throw new IllegalArgumentException("Invalid day " + n);
        }
        this.set(5, n);
        this.complete();
    }

    public final String getMonthName() {
        return month_name[this.get(2)];
    }

    public final long getTimeInMillis() {
        this.complete();
        return super.getTimeInMillis();
    }

    public final Date getCurrentTime() {
        this.complete();
        return super.getTime();
    }

    public final void setCurrentTime(Date date) {
        super.setTime(date);
        this.computeFields();
    }

    public final void moveMonth(boolean bl) {
        this.add(2, bl ? 1 : -1);
        this.complete();
    }

    public void setToWeekDay(int n, boolean bl) {
        if (n < this.getMinimum(7) || n > this.getMaximum(7)) {
            throw new IllegalArgumentException("Invalid day " + n);
        }
        int n2 = this.get(7);
        int n3 = n - n2;
        if (n3 <= 0 && bl) {
            n3 += 7;
        } else if (n3 >= 0 && !bl) {
            n3 -= 7;
        }
        this.setTimeInMillis(this.getTimeInMillis() + (long)n3 * 86400000L);
        this.computeFields();
    }

    public final void fixFields() {
        this.complete();
        this.computeFields();
    }

    public void checkFields() {
        if (this.areFieldsSet) {
            System.out.println("FS 1");
        } else {
            System.out.println("FS 0");
        }
        if (this.isSet(14)) {
            System.out.println("MS 1");
        } else {
            System.out.println("MS 0");
        }
        if (this.isSet(13)) {
            System.out.println("S  1");
        } else {
            System.out.println("S  0");
        }
        if (this.isSet(12)) {
            System.out.println("M  1");
        } else {
            System.out.println("M  0");
        }
        if (this.isSet(10)) {
            System.out.println("H  1");
        } else {
            System.out.println("H  0");
        }
        if (this.isSet(9)) {
            System.out.println("AP 1");
        } else {
            System.out.println("AP 0");
        }
        if (this.isSet(5)) {
            System.out.println("DM 1");
        } else {
            System.out.println("DM 0");
        }
        if (this.isSet(2)) {
            System.out.println("Mo 1");
        } else {
            System.out.println("Mo 0");
        }
        if (this.isSet(7)) {
            System.out.println("DW 1");
        } else {
            System.out.println("DW 0");
        }
        if (this.isSet(3)) {
            System.out.println("WY 1");
        } else {
            System.out.println("WY 0");
        }
        System.out.println();
    }

    public void printFields() {
        System.out.println(this.get(10) + " h " + this.get(12) + " m " + this.get(9) + " apm");
        System.out.println(this.get(5) + " / " + this.get(2) + " / " + this.get(1));
        System.out.println(this.get(7) + " dw " + this.get(6) + " dy " + this.get(3) + " wy");
        System.out.println("For " + this.toString() + "\n");
    }
}

