/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.test;

import org.ariane.exec.RandomTask;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

class TryTask
extends TryProg
implements Runnable {
    private Thread maintask;
    private RandomTask task;
    private String taskname;
    private int loops;

    public static void main(String[] stringArray) {
        TryTask tryTask = new TryTask("TryTask");
        if (!tryTask.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            return;
        }
        if (!tryTask.build()) {
            System.err.println("Can't build TryTask !");
            return;
        }
        if (!tryTask.start()) {
            System.err.println("Can't start TryTask !");
            return;
        }
    }

    public TryTask(String string) {
        super(string);
    }

    public boolean build() {
        this.task = new RandomTask(this.taskname, this.loops);
        this.maintask = new Thread((Runnable)this, this.getName());
        return true;
    }

    public boolean start() {
        if (ToolBox.verbose) {
            System.err.println("Running " + this.taskname + " " + this.loops + " times ...");
        }
        this.maintask.start();
        return true;
    }

    public void run() {
        this.task.start();
        while (!this.task.isDone()) {
            System.err.println("Count " + this.task.getCount());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n2 = 1;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'n': {
                        this.loops = Integer.parseInt(stringArray[n++]);
                    }
                }
                ++n2;
            }
        }
        if (n >= stringArray.length) {
            return false;
        }
        this.taskname = stringArray[n];
        return !bl;
    }
}

