/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.test;

import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

class TryString
extends TryProg {
    private String string = null;
    private int width = 0;

    public static void main(String[] stringArray) {
        TryString tryString = new TryString("TryString");
        if (!tryString.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            TryProg.exitWrong();
        }
        if (!tryString.run()) {
            System.err.println("Can't execute TryString !");
            TryProg.exitWrong();
        }
    }

    public TryString(String string) {
        super(string);
    }

    public boolean run() {
        if (ToolBox.verbose) {
            System.out.println("Running TryString on " + this.string + " ...");
        }
        System.out.println("-" + ToolBox.centerString(this.string, this.width) + "-");
        System.out.println("-" + ToolBox.padString(this.string, this.width) + "-");
        return true;
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n2 = 1;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'w': {
                        this.width = Integer.parseInt(stringArray[n++]);
                    }
                }
                ++n2;
            }
        }
        if (n >= stringArray.length) {
            return false;
        }
        this.string = stringArray[n];
        return !bl;
    }
}

