/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.test;

import org.ariane.stats.ValueCountSet;
import org.ariane.tools.InputDataset;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

class TryStat
extends TryProg {
    private String filename;
    private ValueCountSet set = new ValueCountSet("Statistics");

    public static void main(String[] stringArray) {
        TryStat tryStat = new TryStat("TryStat");
        if (!tryStat.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            return;
        }
        if (!tryStat.run()) {
            System.err.println("Can't execute TryStat !");
            return;
        }
    }

    public TryStat(String string) {
        super(string);
    }

    public boolean run() {
        if (ToolBox.verbose) {
            System.err.println("Running TryStat on " + this.filename + " ...");
        }
        if (!this.load()) {
            System.err.println("Can't load data !");
            return false;
        }
        this.set.sort();
        this.set.dump();
        return true;
    }

    private boolean load() {
        InputDataset inputDataset = new InputDataset(this.filename);
        if (ToolBox.debug) {
            inputDataset.dump();
        }
        int n = 0;
        try {
            String string;
            inputDataset.open();
            while ((string = inputDataset.getNextLine()) != null) {
                this.set.count(Integer.parseInt(string));
                ++n;
            }
            inputDataset.close();
        }
        catch (Exception exception) {
            System.err.println("Can't read file " + inputDataset.getName() + " !");
            System.out.println("Exception caught : " + exception + " line " + n + " !");
            return false;
        }
        this.set.trimToSize();
        return true;
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n2 = 1;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                    }
                }
                ++n2;
            }
        }
        if (n >= stringArray.length) {
            return false;
        }
        this.filename = stringArray[n];
        return !bl;
    }
}

