/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.test;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.ariane.tools.Nobject;
import org.ariane.tools.ToolBox;

class TrySerial
extends Nobject {
    private transient String filename = null;
    private transient boolean dowrite = false;

    public static void main(String[] stringArray) {
        TrySerial trySerial = new TrySerial();
        if (!trySerial.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            return;
        }
        trySerial.run();
    }

    public TrySerial() {
        super("TrySerial");
    }

    private void run() {
        if (this.dowrite) {
            ToolBox.warn("Writing to " + this.filename);
            this.write();
        } else {
            ToolBox.warn("Reading in " + this.filename);
            this.read();
        }
    }

    private void write() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.filename);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            Target target = new Target("sample");
            objectOutputStream.writeObject(target);
            objectOutputStream.close();
            if (ToolBox.verbose) {
                ToolBox.warn("Written  : " + target.toString());
            }
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't write the object", iOException);
            iOException.printStackTrace();
        }
    }

    private void read() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.filename);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Target target = (Target)objectInputStream.readObject();
            objectInputStream.close();
            ToolBox.warn("Read     : " + target.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            ToolBox.warn("Can't create the object", classNotFoundException);
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't read the object", iOException);
            iOException.printStackTrace();
        }
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'q': {
                        ToolBox.verbose = false;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        ToolBox.debug = false;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'r': {
                        this.dowrite = false;
                        break;
                    }
                    case 'w': {
                        this.dowrite = true;
                        break;
                    }
                    default: {
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        if (n < stringArray.length) {
            this.filename = stringArray[n++];
        } else {
            ++n2;
        }
        return n2 == 0;
    }

    class Target
    extends Nobject
    implements Serializable {
        static final long serialVersionUID = -4930254239926841853L;

        protected Target(String string) {
            super(string);
        }

        public String toString() {
            return "New implementation of " + this.getName();
        }
    }
}

