/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.test;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import org.ariane.time.Calendar;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

class TryRWurl
extends TryProg {
    private String target = null;
    private String message = null;
    private boolean dowrite = false;

    public static void main(String[] stringArray) {
        TryRWurl tryRWurl = new TryRWurl();
        if (!tryRWurl.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            return;
        }
        tryRWurl.run();
    }

    public TryRWurl() {
        super("TryRWurl");
    }

    private void run() {
        if (this.dowrite) {
            ToolBox.warn("Writing to " + this.target);
            this.write();
        } else {
            ToolBox.warn("Reading in " + this.target);
            this.read();
        }
    }

    private void write() {
        try {
            OutputStreamWriter outputStreamWriter;
            Object object;
            if (this.isURL(this.target)) {
                object = new URL(this.target);
                URLConnection uRLConnection = ((URL)object).openConnection();
                uRLConnection.setDoOutput(true);
                outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
            } else {
                object = new FileOutputStream(this.target);
                outputStreamWriter = new OutputStreamWriter((OutputStream)object);
            }
            object = new PrintWriter(outputStreamWriter);
            this.message = "Message issued by " + this.getName() + " on " + new Calendar().toString();
            ((PrintWriter)object).println(this.message);
            ((PrintWriter)object).close();
            if (ToolBox.verbose) {
                ToolBox.warn("Message written to " + this.target);
            }
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't write the message", iOException);
            iOException.printStackTrace();
        }
    }

    private void read() {
        try {
            InputStreamReader inputStreamReader;
            Object object;
            if (this.isURL(this.target)) {
                object = new URL(this.target);
                URLConnection uRLConnection = ((URL)object).openConnection();
                inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            } else {
                object = new FileInputStream(this.target);
                inputStreamReader = new InputStreamReader((InputStream)object);
            }
            object = new BufferedReader(inputStreamReader);
            this.message = ((BufferedReader)object).readLine();
            ((BufferedReader)object).close();
            ToolBox.warn("Read     : " + this.message);
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't read the message", iOException);
            iOException.printStackTrace();
        }
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                switch (c) {
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 's': {
                        this.message = stringArray[n++];
                        break;
                    }
                    case 'r': {
                        this.dowrite = false;
                        break;
                    }
                    case 'w': {
                        this.dowrite = true;
                        break;
                    }
                    default: {
                        ++n2;
                    }
                }
                ++n3;
            }
        }
        if (n < stringArray.length) {
            this.target = stringArray[n++];
        } else {
            ++n2;
        }
        return n2 == 0;
    }

    private boolean isURL(String string) {
        return string.indexOf("://") >= 0;
    }
}

