/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.test;

import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

class TryMemory
extends TryProg {
    private int number = 0;
    private long freemem;
    private Runtime rt = Runtime.getRuntime();

    public static void main(String[] stringArray) {
        TryMemory tryMemory = new TryMemory("TryMemory");
        if (!tryMemory.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            return;
        }
        if (!tryMemory.run()) {
            System.err.println("Can't execute TryMemory !");
            return;
        }
    }

    public TryMemory(String string) {
        super(string);
    }

    public boolean run() {
        if (ToolBox.verbose) {
            System.out.println("Running TryMemory ...");
        }
        try {
            this.freemem = this.rt.freeMemory();
            System.out.println("At the beginning : Memory free : " + this.freemem + " total : " + this.rt.freeMemory());
            if (this.number < 1) {
                return true;
            }
            Sample[] sampleArray = new Sample[this.number];
            this.printInfo("Array of " + this.number + " entries :");
            int n = 0;
            while (n < this.number) {
                sampleArray[n] = new Sample();
                ++n;
            }
            this.printInfo("Array of " + this.number + " samples :");
        }
        catch (Exception exception) {
            ToolBox.warn("Something went wrong", exception);
            return false;
        }
        return true;
    }

    private void printInfo(String string) {
        System.out.print(string);
        long l = this.rt.freeMemory();
        System.out.println(" memory free : " + l + " delta : " + (this.freemem - l));
        this.freemem = l;
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n2 = 1;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'n': {
                        this.number = Integer.parseInt(stringArray[n++]);
                    }
                }
                ++n2;
            }
        }
        return !bl;
    }

    private class Sample {
        byte[] s = new byte[1000];

        private Sample() {
            this.s[0] = 100;
        }
    }
}

