/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.test;

import org.ariane.tools.InputDataset;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

class TryFile
extends TryProg {
    private String filename = "";

    public static void main(String[] stringArray) {
        TryFile tryFile = new TryFile("TryFile");
        if (!tryFile.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            return;
        }
        if (!tryFile.run()) {
            System.err.println("Can't execute TryFile !");
            return;
        }
    }

    public TryFile(String string) {
        super(string);
    }

    public boolean run() {
        if (ToolBox.verbose) {
            System.err.println("Running TryFile on " + this.filename + " ...");
        }
        InputDataset inputDataset = new InputDataset(this.filename);
        if (ToolBox.debug) {
            inputDataset.dump();
        }
        try {
            String string;
            inputDataset.open();
            while ((string = inputDataset.getNextLine()) != null) {
                System.out.println(inputDataset.lineNumber() + " " + string);
            }
            inputDataset.close();
        }
        catch (Exception exception) {
            System.err.println("Can't read file " + inputDataset.getName() + " !");
            System.out.println("Exception caught : " + exception + " !");
            return false;
        }
        return true;
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n2 = 1;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                    }
                }
                ++n2;
            }
        }
        if (n >= stringArray.length) {
            return false;
        }
        this.filename = stringArray[n];
        return !bl;
    }
}

