/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.test;

import org.ariane.net.NetDomain;
import org.ariane.net.NetHost;
import org.ariane.net.OurDomain;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

class TryDomain
extends TryProg {
    private NetDomain domain = null;
    private NetHost host = null;

    public static void main(String[] stringArray) {
        TryDomain tryDomain = new TryDomain();
        if (!tryDomain.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            return;
        }
        tryDomain.run();
    }

    public TryDomain() {
        super("TryDomain");
    }

    public void run() {
        if (this.domain == null) {
            this.domain = OurDomain.instance();
        }
        if (ToolBox.debug) {
            ToolBox.warn(this.domain.toString());
        }
        if (this.host == null) {
            this.host = new NetHost();
        }
        if (this.host.isInDomain(this.domain)) {
            ToolBox.warn(this.host.getName() + " is in " + this.domain.getName());
        } else {
            ToolBox.warn(this.host.getName() + " is not in " + this.domain.getName());
        }
    }

    public boolean parseArg(String[] stringArray) {
        int n;
        String[] stringArray2;
        int n2 = 0;
        int n3 = 0;
        while (n2 < stringArray.length && stringArray[n2].startsWith("-")) {
            stringArray2 = stringArray[n2++];
            n = 1;
            while (n < stringArray2.length()) {
                char c = stringArray2.charAt(n);
                switch (c) {
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'h': {
                        this.host = new NetHost(stringArray[n2++]);
                        break;
                    }
                    default: {
                        ++n3;
                    }
                }
                ++n;
            }
        }
        if (n2 < stringArray.length) {
            this.domain = new NetDomain("unknown");
            stringArray2 = new String[stringArray.length - n2];
            n = 0;
            while (n < stringArray2.length) {
                stringArray2[n] = stringArray[n2++];
                ++n;
            }
            this.domain.define(stringArray2);
        }
        return n3 == 0;
    }
}

