/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.test;

import org.ariane.time.Calendar;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

class TryDay
extends TryProg {
    private boolean forward = true;
    private int nbr = 3;
    private int day;

    public static void main(String[] stringArray) {
        TryDay tryDay = new TryDay("TryDay");
        if (!tryDay.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            return;
        }
        if (!tryDay.run()) {
            System.err.println("Can't execute TryDay !");
            return;
        }
    }

    public TryDay(String string) {
        super(string);
        Calendar calendar = new Calendar();
        this.day = calendar.get(7);
    }

    public boolean run() {
        if (ToolBox.verbose) {
            System.out.println("Running TryDay ...");
        }
        Calendar calendar = new Calendar();
        int n = 0;
        while (n < this.nbr) {
            calendar.setToWeekDay(this.day, this.forward);
            System.out.println(calendar.toString());
            ++n;
        }
        return true;
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n2 = 1;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case 'f': {
                        this.forward = true;
                        break;
                    }
                    case 'b': {
                        this.forward = false;
                        break;
                    }
                    case 'n': {
                        this.nbr = Integer.parseInt(stringArray[n++]);
                        break;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'd': {
                        this.day = Integer.parseInt(stringArray[n++]);
                    }
                }
                ++n2;
            }
        }
        return !bl;
    }
}

