/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.test;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.ariane.security.Controller;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

class TryController
extends TryProg {
    private String user = null;
    private String passwd = null;
    private String filename = null;
    private static final String signext = ".sig";
    private boolean dosign = false;

    public static void main(String[] stringArray) {
        TryController tryController = new TryController("TryController");
        if (!tryController.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            System.err.println("Usage : [-vd] [-c|s] -u user [-p password] filename");
            return;
        }
        if (!tryController.run()) {
            System.err.println("Can't execute TryController !");
            return;
        }
    }

    public TryController(String string) {
        super(string);
    }

    public boolean run() {
        try {
            Controller controller = new Controller();
            if (ToolBox.debug) {
                controller.dump();
            }
            String string = this.getPhrase();
            if (this.dosign) {
                this.signPhrase(controller, string);
            } else {
                boolean bl = this.verifyPhrase(controller, string);
                if (bl) {
                    ToolBox.warn("Congratulations Mister " + this.user);
                } else {
                    ToolBox.warn("You're a liar Mister " + this.user);
                }
            }
        }
        catch (Exception exception) {
            ToolBox.warn("Can't run TryController", exception);
            return false;
        }
        return true;
    }

    private final String getPhrase() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.filename);
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            int n2 = fileInputStream.read(byArray);
            fileInputStream.close();
            return new String(byArray);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't read " + this.filename, exception);
            return null;
        }
    }

    private final void signPhrase(Controller controller, String string) {
        try {
            long l = System.currentTimeMillis();
            byte[] byArray = controller.signPhrase(string, this.user, this.passwd.toCharArray());
            ToolBox.warn("Phrase signed in " + (System.currentTimeMillis() - l) + " ms. P/S sizes : " + string.length() + "/" + byArray.length);
            FileOutputStream fileOutputStream = new FileOutputStream(ToolBox.markAsTemp(this.filename + signext));
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            ToolBox.warn("Can't sign the phrase", exception);
        }
    }

    private final boolean verifyPhrase(Controller controller, String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(ToolBox.markAsTemp(this.filename + signext));
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            int n2 = fileInputStream.read(byArray);
            fileInputStream.close();
            return controller.verifyPhrase(string, this.user, byArray);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't verify the phrase", exception);
            return false;
        }
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n2 = 1;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case 's': {
                        this.dosign = true;
                        break;
                    }
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'u': {
                        this.user = stringArray[n++];
                        break;
                    }
                    case 'p': {
                        this.passwd = stringArray[n++];
                    }
                }
                ++n2;
            }
        }
        if (n >= stringArray.length) {
            return false;
        }
        this.filename = stringArray[n];
        this.resources.copyFromSystem("KeyStore.File");
        return !bl;
    }
}

