/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.test;

import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;
import org.ariane.security.Controller;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

class ShowPerm
extends TryProg {
    private String location = null;
    private String user = null;

    public static void main(String[] stringArray) {
        ShowPerm showPerm = new ShowPerm("ShowPerm");
        if (!showPerm.parseArg(stringArray)) {
            System.err.println("Can't parse command line !");
            return;
        }
        if (!showPerm.run()) {
            System.err.println("Can't execute ShowPerm !");
            return;
        }
    }

    public ShowPerm(String string) {
        super(string);
    }

    public boolean run() {
        if (ToolBox.verbose) {
            System.out.println("Running ShowPerm ...");
        }
        try {
            Policy policy = Policy.getPolicy();
            CodeSource codeSource = this.getCodeSource();
            PermissionCollection permissionCollection = policy.getPermissions(codeSource);
            System.out.println("Code source : " + codeSource.toString() + " user : " + String.valueOf(this.user));
            System.out.println();
            System.out.println(permissionCollection.toString());
        }
        catch (Exception exception) {
            ToolBox.warn("Can't dump permissions", exception);
            return false;
        }
        return true;
    }

    public CodeSource getCodeSource() {
        CodeSource codeSource = null;
        if (this.location == null) {
            this.location = this.resources.get("jvs.home");
            this.location = this.location != null ? "file://" + this.location + "/jvs.jar" : "file:///home/lefevre/soft/Java/src";
        }
        try {
            Certificate[] certificateArray;
            Object object;
            if (this.user != null) {
                object = new Controller();
                certificateArray = new Certificate[]{((Controller)object).getCertificate(this.user)};
            } else {
                certificateArray = null;
            }
            object = new URL(this.location);
            codeSource = new CodeSource((URL)object, certificateArray);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't create code source", exception);
        }
        return codeSource;
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n2 = 1;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                        break;
                    }
                    case 'u': {
                        this.user = stringArray[n++];
                    }
                }
                ++n2;
            }
        }
        if (n < stringArray.length) {
            this.location = stringArray[n++];
        }
        return !bl;
    }
}

