/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.stats;

import java.awt.Dimension;
import java.util.Enumeration;
import org.ariane.stats.CountSet;
import org.ariane.stats.Distribuable;
import org.ariane.stats.ValueCount;
import org.ariane.tools.ToolBox;

public class ValueCountSet
extends CountSet
implements Distribuable {
    private int mini = Integer.MIN_VALUE;
    private int maxi = Integer.MAX_VALUE;

    public ValueCountSet(String string) {
        super(string);
    }

    public void count(int n) {
        if (n < this.mini || n > this.maxi) {
            return;
        }
        ValueCount valueCount = this.find(n);
        if (valueCount == null) {
            this.add(new ValueCount(n, 1));
        } else {
            valueCount.increment();
        }
    }

    private ValueCount find(int n) {
        ValueCount valueCount = new ValueCount(n);
        int n2 = this.table.indexOf(valueCount);
        if (n2 < 0) {
            return null;
        }
        return (ValueCount)this.table.elementAt(n2);
    }

    public final void fillUp() {
        int n = this.maxValue() + 2;
        int n2 = 0;
        while (n2 < n) {
            if (this.find(n2) == null) {
                this.add(new ValueCount(n2, 0));
            }
            ++n2;
        }
    }

    public final void sort() {
        int n;
        int n2 = this.table.size();
        Object[] objectArray = new ValueCount[n2];
        this.table.copyInto(objectArray);
        this.table.removeAllElements();
        int n3 = n2 - 2;
        while (n3 >= 0) {
            int n4;
            Object object;
            n = n3 + 1;
            while (n < n2) {
                if (((ValueCount)objectArray[n3]).compareTo((ValueCount)objectArray[n]) > 0) {
                    object = objectArray[n3];
                    n4 = n3 + 1;
                    while (n4 < n) {
                        objectArray[n4 - 1] = objectArray[n4];
                        ++n4;
                    }
                    objectArray[n - 1] = object;
                    break;
                }
                ++n;
            }
            if (n == n2) {
                object = objectArray[n3];
                n4 = n3 + 1;
                while (n4 < n2) {
                    objectArray[n4 - 1] = objectArray[n4];
                    ++n4;
                }
                objectArray[n2 - 1] = object;
            }
            --n3;
        }
        n = 0;
        while (n < n2) {
            this.table.addElement(objectArray[n]);
            ++n;
        }
    }

    public Dimension getBounds() {
        if (this.size() < 1) {
            return new Dimension();
        }
        Dimension dimension = new Dimension(this.maxValue(), this.maxCount());
        if (ToolBox.debug) {
            System.out.println("Bounds : " + dimension.toString());
        }
        return dimension;
    }

    public final int maxValue() {
        int n = this.mini;
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            int n2 = ((ValueCount)enumeration.nextElement()).value();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public final float meanValue() {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            ValueCount valueCount = (ValueCount)enumeration.nextElement();
            int n3 = valueCount.getCount();
            n2 += n3;
            n += n3 * valueCount.value();
        }
        if (n2 < 1) {
            return 0.0f;
        }
        return (float)n / (float)n2;
    }

    public final float meanSquareValue() {
        float f = this.meanValue();
        double d = 0.0;
        int n = 0;
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            ValueCount valueCount = (ValueCount)enumeration.nextElement();
            int n2 = valueCount.getCount();
            float f2 = f - (float)valueCount.value();
            n += n2;
            d += (double)((float)n2 * f2 * f2);
        }
        if (n < 1) {
            return 0.0f;
        }
        return (float)Math.sqrt(d / (double)(n - 1));
    }

    public void dump() {
        super.dump();
        System.out.println("Mean value : " + this.meanValue() + " Mean square value : " + this.meanSquareValue() + " !");
        System.out.println("Bounds : " + this.getBounds().toString() + " !");
        System.out.println();
    }

    public void getValues(float[] fArray, float[] fArray2) {
        int n = this.table.size();
        int n2 = 0;
        while (n2 < n) {
            ValueCount valueCount = (ValueCount)this.table.elementAt(n2);
            fArray2[n2] = valueCount.getCount();
            fArray[n2] = valueCount.value();
            ++n2;
        }
    }
}

