/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.stats;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import org.ariane.stats.CountSet;
import org.ariane.stats.DatedCount;
import org.ariane.time.Duration;
import org.ariane.tools.InputDataset;
import org.ariane.tools.StreamReader;
import org.ariane.tools.ToolBox;

public class DatedCountSet
extends CountSet {
    public DatedCountSet(String string) {
        super(string);
    }

    public void read(String string) throws IOException {
        String string2;
        if (ToolBox.debug) {
            System.out.print("Reading Dated Count Set " + this.getName());
            System.out.println(" in file " + string + " ...");
        }
        InputDataset inputDataset = new InputDataset(string);
        StreamReader streamReader = inputDataset.createReader();
        long l = 0L;
        while ((string2 = streamReader.nextLine()) != null) {
            DatedCount datedCount = new DatedCount(string2);
            this.add(datedCount);
            l += (long)datedCount.getCount();
            if (!ToolBox.debug) continue;
            System.out.println(datedCount.toString());
        }
        inputDataset.close();
        this.trimToSize();
        if (ToolBox.verbose) {
            System.out.println(this.getName() + " read " + this.size() + " elements. Total : " + l + " !");
        }
    }

    public Duration getDuration() {
        if (this.size() < 2) {
            return new Duration();
        }
        Date date = ((DatedCount)this.getFirst()).date();
        Date date2 = ((DatedCount)this.getLast()).date();
        return new Duration(date, date2);
    }

    public final void roundToQuarter() {
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            DatedCount datedCount = (DatedCount)enumeration.nextElement();
            datedCount.roundToQuarter();
        }
    }

    public DatedCountSet expand() {
        DatedCountSet datedCountSet = new DatedCountSet(this.getName());
        Enumeration enumeration = this.table.elements();
        DatedCount datedCount = (DatedCount)enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            DatedCount datedCount2 = (DatedCount)enumeration.nextElement();
            int n = new Duration(datedCount.date(), datedCount2.date()).inHalfHours();
            if (n < 1) {
                ToolBox.warn("DatedCountSet : value ignored : " + datedCount2.toString());
                continue;
            }
            datedCountSet.add(datedCount);
            if (n > 1) {
                DatedCount datedCount3 = datedCount;
                int n2 = 1;
                while (n2 < n) {
                    datedCount3 = new DatedCount(datedCount3.date(), 30);
                    datedCountSet.add(datedCount3);
                    ++n2;
                }
            }
            datedCount = datedCount2;
        }
        datedCountSet.add(datedCount);
        datedCountSet.trimToSize();
        return datedCountSet;
    }

    public DatedCountSet compress(int n) {
        if (n < 2) {
            return this;
        }
        DatedCountSet datedCountSet = new DatedCountSet(this.getName());
        Enumeration enumeration = this.table.elements();
        DatedCount datedCount = null;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            DatedCount datedCount2 = (DatedCount)enumeration.nextElement();
            if (datedCount == null) {
                n2 = datedCount2.getCount();
                datedCount = datedCount2;
                continue;
            }
            int n3 = new Duration(datedCount.date(), datedCount2.date()).inHalfHours() + 1;
            if (n3 < n) {
                n2 += datedCount2.getCount();
                continue;
            }
            if (n3 != n) continue;
            DatedCount datedCount3 = new DatedCount(datedCount.date(), 0);
            datedCount3.setCount(n2 += datedCount2.getCount());
            datedCountSet.add(datedCount3);
            datedCount = null;
        }
        datedCountSet.trimToSize();
        return datedCountSet;
    }
}

