/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.stats;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ariane.stats.ObjectCount;
import org.ariane.time.Calendar;
import org.ariane.time.Time;

public class DatedCount
extends ObjectCount {
    public DatedCount() {
        super(new Calendar(), 0);
        this.getCalendar().setTime(new Date());
    }

    public DatedCount(Date date, int n) {
        super(new Calendar(), 0);
        this.getCalendar().setTime(date);
        this.getCalendar().add(12, n);
    }

    public DatedCount(String string) throws IllegalArgumentException {
        String string2 = new String(" : ");
        int n = 4;
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            throw new IllegalArgumentException("No separator found");
        }
        try {
            this.object = this.parseDate(string.substring(0, n2));
            this.count = Integer.parseInt(string.substring(n2 + n).trim());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't parse " + string);
        }
    }

    public final String day() {
        Time time = new Time(this.getCalendar());
        return time.dayMonth();
    }

    public final int weekDay() {
        return this.getCalendar().get(7);
    }

    public final int monthDay() {
        return this.getCalendar().get(5);
    }

    public final Date date() {
        return this.getCalendar().getTime();
    }

    private final Calendar getCalendar() {
        return (Calendar)this.object;
    }

    public String toString() {
        return this.date().getTime() + " " + this.weekDay() + " " + this.monthDay() + " " + " : " + this.count;
    }

    public final void roundToQuarter() {
        Calendar calendar = this.getCalendar();
        calendar.set(14, 0);
        calendar.set(13, 0);
        int n = 15 * (calendar.get(12) / 15);
        calendar.set(12, n);
    }

    public final boolean isInInterval(int n, int n2) {
        if (n < 1 && n2 > 23) {
            return true;
        }
        int n3 = this.getCalendar().get(10);
        if (n < n2) {
            return n <= n3 && n3 <= n2;
        }
        if (n > n2) {
            return n <= n3 && n3 <= 23 || 0 <= n3 && n3 <= n2;
        }
        return false;
    }

    private Calendar parseDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        Calendar calendar = new Calendar();
        simpleDateFormat.setTimeZone(Calendar.LTZ);
        calendar.setTime(simpleDateFormat.parse(string.trim()));
        return calendar;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage : java org.ariane.stats.DatedCount string");
            return;
        }
        System.out.println("string : " + stringArray[0]);
        DatedCount datedCount = new DatedCount(stringArray[0]);
        System.out.println(datedCount.toString());
    }
}

