/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import org.ariane.security.SecurityException;
import org.ariane.tools.Resources;
import org.ariane.tools.ToolBox;

public class Controller {
    private KeyStore keystore = null;
    private Signature signer = null;

    public Controller() throws SecurityException {
        this.loadKeyStore();
        try {
            this.signer = Signature.getInstance("SHA1withDSA");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurityException("Can't create signer " + generalSecurityException.getMessage());
        }
    }

    private void loadKeyStore() throws SecurityException {
        Resources resources = Resources.instance();
        String string = System.getProperty("user.home") + System.getProperty("file.separator") + ".keystore";
        String string2 = resources.get("KeyStore.File", string);
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keystore.load(fileInputStream, null);
            if (ToolBox.debug) {
                ToolBox.warn("Keystore loaded from " + string2);
            }
        }
        catch (IOException iOException) {
            throw new SecurityException("Can't read " + string2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.keystore = null;
            throw new SecurityException("Can't load keystore " + generalSecurityException.getMessage());
        }
    }

    public final byte[] signPhrase(String string, String string2, char[] cArray) throws SecurityException {
        if (string == null || string2 == null || cArray == null) {
            throw new IllegalArgumentException("Invalid null arguments");
        }
        try {
            Key key = this.keystore.getKey(string2, cArray);
            if (key == null) {
                throw new SecurityException("No key for " + string2);
            }
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(key.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            this.signer.initSign(privateKey);
            this.signer.update(string.getBytes());
            return this.signer.sign();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurityException("Can't sign the phrase (" + generalSecurityException.getMessage() + ")");
        }
    }

    public final byte[] SignPhrase(String string, String string2, char[] cArray) throws SecurityException {
        return this.signPhrase(string, string2, cArray);
    }

    public final boolean verifyPhrase(String string, String string2, byte[] byArray) {
        if (string == null || string2 == null || byArray == null) {
            throw new IllegalArgumentException("Invalid null arguments");
        }
        try {
            Certificate certificate = this.keystore.getCertificate(string2);
            if (certificate == null) {
                ToolBox.warn("User " + string2 + " unknown");
                return false;
            }
            PublicKey publicKey = certificate.getPublicKey();
            this.signer.initVerify(publicKey);
            this.signer.update(string.getBytes());
            return this.signer.verify(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (ToolBox.debug) {
                generalSecurityException.printStackTrace();
            }
            ToolBox.warn("Can't verify signature", generalSecurityException);
            return false;
        }
        catch (Exception exception) {
            if (ToolBox.debug) {
                exception.printStackTrace();
            }
            ToolBox.warn("Can't verify signature", exception);
            return false;
        }
    }

    public final Certificate getCertificate(String string) throws KeyStoreException {
        return this.keystore.getCertificate(string);
    }

    public String toString() {
        return "Controller";
    }

    public void dump() {
        if (this.keystore == null) {
            System.out.println("Keystore is null");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Keystore type ");
        stringBuffer.append(this.keystore.getType()).append(" provider ");
        stringBuffer.append(this.keystore.getProvider().getName());
        System.out.println(stringBuffer);
    }
}

