/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.ariane.net.HostTag;
import org.ariane.net.TagConnection;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

public class TagServer
extends TryProg
implements Runnable {
    private HostTag tag = new HostTag();
    private boolean alive = false;
    public static final String APPLI = "TagServer";
    private Thread thread = null;
    private ServerSocket socket;

    public TagServer() {
        super(APPLI);
    }

    public void stop() {
        try {
            this.alive = false;
            this.socket.close();
            if (ToolBox.verbose) {
                ToolBox.warn("TagServer dead");
            }
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't close socket TagServer", iOException);
        }
    }

    public void start() {
        int n = this.resources.get("TagServer.Port", 1333);
        if (n < 0) {
            ToolBox.warn("Can't find port number");
            return;
        }
        try {
            this.socket = new ServerSocket(n);
            this.alive = true;
            this.thread = new Thread((Runnable)this, APPLI);
            this.thread.start();
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't make socket TagServer", iOException);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't start TagServer", exception);
            this.thread = null;
        }
    }

    public void run() {
        if (ToolBox.verbose) {
            ToolBox.warn("TagServer " + this.tag.getHostName() + " " + this.tag.getIPnumber() + " started");
        }
        try {
            do {
                Socket socket = this.socket.accept();
                TagConnection tagConnection = new TagConnection(this, socket, this.tag);
                tagConnection.start();
            } while (this.alive);
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't accept connection", iOException);
        }
        catch (Exception exception) {
            ToolBox.warn("Exception handled", exception);
        }
        if (ToolBox.debug) {
            ToolBox.warn("TagServer terminated");
        }
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n2 = 1;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                    }
                }
                ++n2;
            }
        }
        return !bl;
    }
}

