/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.ariane.exec.RunnableTask;
import org.ariane.net.HostTag;
import org.ariane.net.TagServer;
import org.ariane.tools.ToolBox;

public class TagConnection
extends RunnableTask {
    private TagServer server;
    private Socket socket;
    private HostTag tag;
    public static final byte HI = 1;
    public static final byte TAG = 2;
    public static final byte DOWN = 3;
    public static final byte BYE = 4;
    public static final byte NDF = 9;

    public TagConnection(TagServer tagServer, Socket socket, HostTag hostTag) {
        this.server = tagServer;
        this.socket = socket;
        this.tag = hostTag;
    }

    public void run() {
        this.done = false;
        if (ToolBox.debug) {
            ToolBox.warn("TagConnection  started");
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(this.socket.getInputStream());
            byte by = this.receiveCommand(dataInputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
            switch (by) {
                case 2: {
                    this.tag.touch();
                    ToolBox.warn("Connection " + this.tag.toString());
                    this.sendString(dataOutputStream, this.tag.toString());
                    break;
                }
                case 3: {
                    ToolBox.warn("Server goes dead");
                    this.server.stop();
                    break;
                }
                default: {
                    ToolBox.warn("Unknown command " + by);
                    this.sendString(dataOutputStream, "What ?");
                    break;
                }
            }
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't communicate", iOException);
        }
        this.done = true;
        if (ToolBox.debug) {
            ToolBox.warn("TagConnection done");
        }
    }

    private byte receiveCommand(DataInputStream dataInputStream) throws IOException {
        int n = 4;
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray, 0, n);
        if (byArray[0] != 1 || byArray[2] != 4) {
            ToolBox.warn("Can't understand cmd " + byArray[0] + " " + byArray[1] + " " + byArray[2] + " " + byArray[3]);
            return 9;
        }
        return byArray[1];
    }

    private void sendString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeBytes(string);
        dataOutputStream.writeByte(10);
        dataOutputStream.flush();
    }
}

