/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.net;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import org.ariane.tools.ToolBox;
import org.ariane.tools.TryProg;

class TagClient
extends TryProg {
    private String server;
    private int port;

    public static void main(String[] stringArray) {
        ToolBox.debug = true;
        TagClient tagClient = new TagClient();
        if (!tagClient.parseArg(stringArray)) {
            ToolBox.warn("Can't parse command line");
            return;
        }
        if (!tagClient.run()) {
            ToolBox.warn("Can't execute command");
            return;
        }
    }

    public TagClient() {
        super("TagClient");
        this.server = this.resources.get("TagServer.Server");
        this.port = this.resources.get("TagServer.Port", -1);
        if (ToolBox.debug) {
            ToolBox.warn("Connection to " + this.server + " " + this.port);
        }
    }

    public boolean run() {
        boolean bl = true;
        ToolBox.warn("TagClient started ...");
        while (bl) {
            System.out.println();
            System.out.print("Option : ");
            System.out.flush();
            String string = ToolBox.readInputString();
            if (string.equalsIgnoreCase("t")) {
                this.requestTag();
                continue;
            }
            if (string.equalsIgnoreCase("s")) {
                this.shutDown();
                bl = false;
                continue;
            }
            if (string.equalsIgnoreCase("q")) {
                bl = false;
                continue;
            }
            if (string.equalsIgnoreCase("x")) {
                bl = false;
                continue;
            }
            ToolBox.warn("Valid options : t(ag) s(shutdown) q(uit)");
        }
        ToolBox.warn("TagClient terminated");
        return true;
    }

    private void shutDown() {
        if (ToolBox.debug) {
            ToolBox.warn("ShutDown " + this.server);
        }
        try {
            Socket socket = new Socket(this.server, this.port);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            this.sendCommand(dataOutputStream, (byte)3);
            this.requestTag();
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't shutdown " + this.server, iOException);
        }
    }

    private void requestTag() {
        if (ToolBox.debug) {
            ToolBox.warn("RequestTag " + this.server);
        }
        try {
            Socket socket = new Socket(this.server, this.port);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            this.sendCommand(dataOutputStream, (byte)2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String string = this.receiveString(bufferedReader);
            System.out.println(string);
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't get tag from " + this.server, iOException);
        }
    }

    private void sendCommand(DataOutputStream dataOutputStream, byte by) throws IOException {
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(by);
        dataOutputStream.writeByte(4);
        dataOutputStream.writeByte(10);
        dataOutputStream.flush();
    }

    private String receiveString(BufferedReader bufferedReader) throws IOException {
        return bufferedReader.readLine();
    }

    public boolean parseArg(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n++];
            int n2 = 1;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                switch (c) {
                    case 'v': {
                        ToolBox.verbose = true;
                        break;
                    }
                    case 'd': {
                        ToolBox.verbose = true;
                        ToolBox.debug = true;
                    }
                }
                ++n2;
            }
        }
        return !bl;
    }
}

