/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.ariane.net.NetDomain;
import org.ariane.tools.Nobject;

public class NetHost
extends Nobject {
    public NetHost(String string) {
        super(string);
    }

    public NetHost() {
        try {
            this.setName(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            this.setName("localhost");
        }
    }

    public String toString() {
        return "Host : " + this.getName();
    }

    public final boolean isInDomain(NetDomain netDomain) {
        return netDomain.has(this);
    }

    public final String getIPnumber() {
        try {
            byte[] byArray = this.getAddress();
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append(byArray[0] & 0xFF).append(".");
            stringBuffer.append(byArray[1] & 0xFF).append(".");
            stringBuffer.append(byArray[2] & 0xFF).append(".");
            stringBuffer.append(byArray[3] & 0xFF);
            return stringBuffer.toString();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }

    public final byte[] getAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getAddress();
    }
}

