/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.net;

import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.ariane.net.NetHost;
import org.ariane.tools.Nobject;
import org.ariane.tools.ToolBox;

public class NetDomain
extends Nobject {
    private byte[][] subnets;

    public NetDomain(String string) {
        super(string);
    }

    public boolean has(NetHost netHost) {
        try {
            byte[] byArray = netHost.getAddress();
            int n = this.subnets.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.isInSubnet(byArray, this.subnets[n2])) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public void define(String[] stringArray) {
        int n = stringArray.length;
        this.subnets = new byte[n][3];
        int n2 = 0;
        while (n2 < n) {
            this.addNet(stringArray[n2], this.subnets[n2]);
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.subnets.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.subnets[n2][0] & 0xFF).append(".");
            stringBuffer.append(this.subnets[n2][1] & 0xFF).append(".");
            stringBuffer.append(this.subnets[n2][2] & 0xFF).append(".* ");
            ++n2;
        }
        return "Domain : " + this.getName() + " [ " + stringBuffer.toString() + "] ";
    }

    private void addNet(String string, byte[] byArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            String string2 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string2);
            byArray[0] = (byte)n;
            string2 = stringTokenizer.nextToken();
            n = Integer.parseInt(string2);
            byArray[1] = (byte)n;
            string2 = stringTokenizer.nextToken();
            n = Integer.parseInt(string2);
            byArray[2] = (byte)n;
        }
        catch (Exception exception) {
            ToolBox.warn("Invalid address " + string, exception);
            throw new IllegalArgumentException(string);
        }
    }

    public final boolean isInSubnet(byte[] byArray, byte[] byArray2) {
        return byArray[0] == byArray2[0] && byArray[1] == byArray2[1] && byArray[2] == byArray2[2];
    }
}

