/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import org.ariane.exec.BackgroundCommand;
import org.ariane.tools.ToolBox;

public class MailBack
extends BackgroundCommand {
    private Socket sock = null;
    private String receiver = null;
    private String subject = "Mad Max Mailback";
    private String text = "";
    private static final String mailer = "dphdse.saclay.cea.fr";
    private static final String sender = "lefevre@hep.saclay.cea.fr";
    private static final String author = "the Java Virtual Shelf";
    private static final String filet = "____________________________________________________________________________";

    public MailBack() {
    }

    public MailBack(String string) {
        this.setSubject(string);
    }

    public final void setReceiver(String string) {
        this.receiver = string;
    }

    public final void setSubject(String string) {
        this.subject = string;
    }

    public final void setText(String string) {
        this.text = string == null ? "" : string;
    }

    public void run() {
        PrintWriter printWriter;
        BufferedReader bufferedReader;
        this.done = false;
        if (this.receiver == null) {
            ToolBox.warn("Invalid null receiver address");
            this.done = true;
            return;
        }
        if (this.receiver.indexOf(64) < 0) {
            ToolBox.warn("Invalid receiver address " + this.receiver);
            this.done = true;
            return;
        }
        try {
            if (ToolBox.debug) {
                ToolBox.warn("Contacting dphdse.saclay.cea.fr");
            }
            this.sock = new Socket(mailer, 25);
        }
        catch (Exception exception) {
            ToolBox.warn("Can't connect to dphdse.saclay.cea.fr", exception);
            this.done = true;
            return;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
            printWriter = new PrintWriter(this.sock.getOutputStream(), true);
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't open streams to dphdse.saclay.cea.fr", iOException);
            this.closeConnection();
            return;
        }
        if (ToolBox.debug) {
            ToolBox.warn("Connected to dphdse.saclay.cea.fr");
        }
        String string = this.getLine(bufferedReader);
        printWriter.println("HELO dphdse.saclay.cea.fr");
        if (!this.isOK(bufferedReader)) {
            ToolBox.warn("Can't greet dphdse.saclay.cea.fr");
            this.closeConnection();
            return;
        }
        printWriter.println("MAIL FROM: lefevre@hep.saclay.cea.fr");
        if (!this.isOK(bufferedReader)) {
            ToolBox.warn("Can't send message from lefevre@hep.saclay.cea.fr");
            this.closeConnection();
            return;
        }
        printWriter.println("RCPT TO: " + this.receiver);
        if (!this.isOK(bufferedReader)) {
            ToolBox.warn("Can't send message to " + this.receiver);
            this.closeConnection();
            return;
        }
        printWriter.println("DATA");
        if (!this.isReady(bufferedReader)) {
            ToolBox.warn("Can't send data");
            this.closeConnection();
            return;
        }
        printWriter.println("To: " + this.receiver);
        printWriter.println("Subject: " + this.subject);
        printWriter.println("From: \"the Java Virtual Shelf\" <lefevre@hep.saclay.cea.fr>");
        printWriter.println("");
        this.sendHeader(printWriter);
        this.sendText(printWriter);
        printWriter.println(".");
        this.getLine(bufferedReader);
        printWriter.println("quit");
        this.closeConnection();
        this.done = true;
    }

    private boolean isOK(BufferedReader bufferedReader) {
        return this.getLine(bufferedReader).regionMatches(0, "250", 0, 3);
    }

    private boolean isReady(BufferedReader bufferedReader) {
        return this.getLine(bufferedReader).regionMatches(0, "354", 0, 3);
    }

    private void sendHeader(PrintWriter printWriter) {
        String string;
        printWriter.println(filet);
        printWriter.println();
        printWriter.println("Greetings,");
        printWriter.println("This message was sent automatically by the JVS Mailback Procedure.");
        try {
            string = InetAddress.getLocalHost().getHostName();
            if (string == null) {
                string = InetAddress.getLocalHost().toString();
            }
        }
        catch (Exception exception) {
            string = "unknown";
        }
        printWriter.println("It was launched from host : " + string + " thru " + System.getProperty("browser", "Unknown") + ".");
        printWriter.println(filet);
    }

    private void sendText(PrintWriter printWriter) {
        printWriter.println();
        printWriter.print(this.text);
        printWriter.println();
        printWriter.print(filet);
        printWriter.println();
    }

    private String getLine(BufferedReader bufferedReader) {
        String string;
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't read line", iOException);
            this.closeConnection();
            this.done = true;
            this.stop();
            return null;
        }
        return string;
    }

    private void closeConnection() {
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            ToolBox.warn("Can't close connection", iOException);
            this.done = true;
        }
    }
}

