/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.net;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.ariane.net.NetHost;
import org.ariane.stats.Countable;
import org.ariane.tools.Nobject;

class HostTag
extends Nobject
implements Countable {
    private int count;
    private Date hour;
    private NetHost host;

    public HostTag(String string, NetHost netHost) {
        super(string);
        this.host = netHost;
        this.count = 0;
        this.hour = new Date();
    }

    public HostTag(String string) {
        this("tag", new NetHost(string));
    }

    public HostTag() {
        this("tag", new NetHost());
    }

    public String toString() {
        return "Tag " + this.getName() + " on " + this.host.getName() + " " + this.getTag();
    }

    public final String getIPnumber() {
        return this.host.getIPnumber();
    }

    public final String getHostName() {
        return this.host.getName();
    }

    public final synchronized int getCount() {
        return this.count;
    }

    private synchronized String getTag() {
        StringBuffer stringBuffer = new StringBuffer("count ");
        stringBuffer.append(this.count).append(" at ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh 'h' mm 'm'");
        stringBuffer.append(simpleDateFormat.format(this.hour));
        return stringBuffer.toString();
    }

    public final synchronized void increment() {
        ++this.count;
    }

    public final synchronized void touch() {
        this.hour = new Date();
        this.increment();
    }
}

