/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class TimerBar
extends JProgressBar {
    private Timer timer;
    private int period = 100;
    private long ti;

    public TimerBar() {
        this.setMinimum(0);
        this.setStringPainted(false);
        this.setValue(this.getMinimum());
        this.setOrientation(0);
    }

    public final void setPeriod(int n) {
        this.period = n;
    }

    public final void start(int n) {
        this.setMaximum(n / 1000);
        this.setValue(this.getMaximum());
        this.ti = System.currentTimeMillis();
        if (this.timer == null) {
            this.createCounter();
        }
        this.timer.start();
    }

    public final void stop() {
        this.setMaximum(0);
        this.setValue(0);
    }

    private void createCounter() {
        this.timer = new Timer(this.period, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                long l = System.currentTimeMillis();
                int n = TimerBar.this.getMaximum() - (int)((l - TimerBar.this.ti) / 1000L);
                if (n < 0) {
                    TimerBar.this.setValue(TimerBar.this.getMinimum());
                    TimerBar.this.timer.stop();
                    return;
                }
                TimerBar.this.setValue(n);
            }
        });
    }
}

