/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.ariane.gui.GuiResourcesOp;
import org.ariane.tools.Resources;

public abstract class GuiResources
implements GuiResourcesOp {
    private Font header_font;
    private Font label_font;
    private Font text_font;
    private Color main_bg;
    private Color main_fg;
    private Color pane_bg;
    private Color pane_fg;
    private Color board_bg;
    private Color board_fg;
    private Color select_bg;
    private Border border;
    private Border in_border;
    private Border out_border;
    private Border line_border;
    private Border matte_border;
    private Border margin_border;
    private int space;

    protected GuiResources() {
        String string = this.getAppplicationPrefix();
        Resources resources = Resources.instance();
        this.header_font = resources.get(string + "Header.Font", "Helvetica", 1, 14);
        this.label_font = resources.get(string + "Label.Font", "Helvetica", 0, 14);
        this.text_font = resources.get(string + "Text.Font", "Helvetica", 0, 12);
        this.main_bg = resources.get(string + "Background", Color.cyan);
        this.main_fg = resources.get(string + "Foreground", Color.black);
        this.pane_bg = resources.get(string + "Pane.Background", Color.white);
        this.pane_fg = resources.get(string + "Pane.Foreground", Color.black);
        this.board_bg = resources.get(string + "Board.Background", this.pane_bg);
        this.board_fg = resources.get(string + "Board.Foreground", this.pane_fg);
        this.select_bg = resources.get(string + "Selection.Background", Color.yellow);
        this.space = resources.get(string + "Space", 2);
        this.border = BorderFactory.createEtchedBorder();
        this.in_border = BorderFactory.createLoweredBevelBorder();
        this.out_border = BorderFactory.createRaisedBevelBorder();
        this.line_border = BorderFactory.createLineBorder(this.main_fg);
        this.matte_border = BorderFactory.createMatteBorder(this.space, this.space, this.space, this.space, this.main_bg);
        this.margin_border = BorderFactory.createEmptyBorder(this.space, this.space, this.space, this.space);
    }

    public abstract String getAppplicationPrefix();

    public final int get(String string, int n) {
        return Resources.instance().get(this.getAppplicationPrefix() + string, n);
    }

    public final String get(String string, String string2) {
        return Resources.instance().get(this.getAppplicationPrefix() + string, string2);
    }

    public final boolean get(String string, boolean bl) {
        return Resources.instance().get(this.getAppplicationPrefix() + string, bl);
    }

    public final String get(String string) {
        return Resources.instance().get(this.getAppplicationPrefix() + string);
    }

    public final Color get(String string, Color color) {
        return Resources.instance().get(this.getAppplicationPrefix() + string, color);
    }

    public final Font getHeaderFont() {
        return this.header_font;
    }

    public final Font getLabelFont() {
        return this.label_font;
    }

    public final Font getTextFont() {
        return this.text_font;
    }

    public final Color getMainBackground() {
        return this.main_bg;
    }

    public final Color getMainForeground() {
        return this.main_fg;
    }

    public final Color getPaneBackground() {
        return this.pane_bg;
    }

    public final Color getPaneForeground() {
        return this.pane_fg;
    }

    public final Color getBoardBackground() {
        return this.board_bg;
    }

    public final Color getBoardForeground() {
        return this.board_fg;
    }

    public final Color getSelectionColor() {
        return this.select_bg;
    }

    public final Border getBorder() {
        return this.border;
    }

    public final Border getInBorder() {
        return this.in_border;
    }

    public final Border getOutBorder() {
        return this.out_border;
    }

    public final Border getLineBorder() {
        return this.line_border;
    }

    public final Border getMatteBorder() {
        return this.matte_border;
    }

    public final Border getMarginBorder() {
        return this.margin_border;
    }

    public final int getSpace() {
        return this.space;
    }

    public final Icon getIcon(String string) {
        return new ImageIcon(Resources.instance().getLibDirectory() + "images/" + string);
    }

    public static void printSizes(String string, JComponent jComponent) {
        System.out.println();
        System.out.println("Geometry of    : " + string);
        Dimension dimension = jComponent.getSize(null);
        System.out.println("Current size w : " + dimension.width + " h : " + dimension.height);
        dimension = jComponent.getMinimumSize();
        System.out.println("Minimum size w : " + dimension.width + " h : " + dimension.height);
        dimension = jComponent.getPreferredSize();
        System.out.println("Preferd size w : " + dimension.width + " h : " + dimension.height);
        dimension = jComponent.getMaximumSize();
        System.out.println("Maximum size w : " + dimension.width + " h : " + dimension.height);
    }
}

