/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.ariane.gui.GuiResourcesOp;

public abstract class Dialog
extends JDialog
implements ActionListener {
    protected static final String OK = "OK";
    protected JButton ok_button;
    protected static final String CANCEL = "Cancel";
    protected JButton cancel_button;
    protected boolean confirmed = false;
    protected JComponent component;
    protected GuiResourcesOp resources;

    protected Dialog(Frame frame) {
        this(frame, null);
    }

    protected Dialog(Frame frame, String string) {
        this(frame, string, null);
    }

    protected Dialog(Frame frame, String string, String string2) {
        super(frame, "Dialog", true);
        this.setResources();
        this.build(string, string2);
    }

    protected Dialog(Frame frame, String string, String string2, boolean bl) {
        super(frame, "Dialog", bl);
        this.setResources();
        this.build(string, string2);
    }

    private void build(String string, String string2) {
        JComponent jComponent;
        int n = this.resources.getSpace();
        Dimension dimension = new Dimension(0, n);
        ((Component)this).setBackground(this.resources.getMainBackground());
        this.setForeground(this.resources.getMainForeground());
        JPanel jPanel = new JPanel();
        this.setContentPane(jPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(this.resources.getMainBackground());
        jPanel.setForeground(this.resources.getMainForeground());
        jPanel.setFont(this.resources.getHeaderFont());
        jPanel.add(Box.createRigidArea(new Dimension(0, 3 * this.resources.getSpace())));
        if (string != null) {
            jComponent = this.createHeader(string, string2);
            jPanel.add(jComponent);
            jPanel.add(Box.createRigidArea(dimension));
        }
        this.component = this.createComponent();
        this.component.setAlignmentX(0.5f);
        jPanel.add(this.component);
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        jComponent.setOpaque(false);
        jComponent.add(Box.createRigidArea(dimension));
        JSeparator jSeparator = new JSeparator(0);
        jComponent.add(jSeparator);
        jComponent.add(Box.createRigidArea(dimension));
        JComponent jComponent2 = this.createButtons();
        jComponent2.setAlignmentX(0.5f);
        jComponent.add(jComponent2);
        jComponent.add(Box.createRigidArea(dimension));
        Dimension dimension2 = new Dimension(2000, 100);
        jComponent.setMaximumSize(dimension2);
        jPanel.add(jComponent);
        this.pack();
    }

    protected abstract JComponent createComponent();

    protected abstract void setResources();

    protected final void setInitialSize(String string, int n, int n2) {
        n = this.resources.get(string + ".Width", n);
        n2 = this.resources.get(string + ".Height", n2);
        this.setBestSize(n, n2);
    }

    protected final Dimension getInitialSize() {
        return ((JComponent)this.getContentPane()).getPreferredSize();
    }

    public final void setBestSize(int n, int n2) {
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setPreferredSize(new Dimension(n, n2));
    }

    private JComponent createHeader(String string, String string2) {
        JLabel jLabel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(false);
        jPanel.add(Box.createRigidArea(new Dimension(this.resources.getSpace(), 0)));
        if (string2 != null) {
            Icon icon = this.resources.getIcon(string2);
            jLabel = new JLabel(icon);
            jLabel.setAlignmentX(0.0f);
            jLabel.setBorder(this.resources.getLineBorder());
            jPanel.add(jLabel);
            jPanel.add(Box.createHorizontalGlue());
            jLabel = new JLabel(string, 2);
            jLabel.setAlignmentX(1.0f);
        } else {
            jLabel = new JLabel(string, 0);
            jLabel.setAlignmentX(0.5f);
        }
        jLabel.setFont(this.resources.getHeaderFont());
        jLabel.setForeground(this.resources.getMainForeground());
        jPanel.add(jLabel);
        return jPanel;
    }

    protected JComponent createButtons() {
        JPanel jPanel = new JPanel();
        Dimension dimension = new Dimension(2 * this.resources.getSpace(), 0);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.setOpaque(false);
        this.ok_button = new JButton(OK);
        this.ok_button.addActionListener(this);
        this.ok_button.setBorder(this.resources.getOutBorder());
        this.ok_button.setToolTipText("To accept the choice");
        this.ok_button.setAlignmentX(0.0f);
        this.ok_button.setOpaque(false);
        this.ok_button.setForeground(this.resources.getMainForeground());
        jPanel.add(this.ok_button);
        jPanel.add(Box.createHorizontalGlue());
        this.cancel_button = new JButton(CANCEL);
        this.cancel_button.addActionListener(this);
        this.cancel_button.setBorder(this.resources.getOutBorder());
        this.cancel_button.setToolTipText("To cancel the operation");
        this.cancel_button.setAlignmentX(1.0f);
        this.cancel_button.setOpaque(false);
        this.cancel_button.setForeground(this.resources.getMainForeground());
        jPanel.add(this.cancel_button);
        jPanel.add(Box.createRigidArea(dimension));
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.confirmed = string.equals(OK);
        ((Component)this).setVisible(false);
    }

    public boolean display() {
        ((Component)this).setVisible(true);
        return this.confirmed;
    }

    protected final Border makeMarginBorder() {
        int n = this.resources.getSpace();
        Border border = this.resources.getInBorder();
        Border border2 = BorderFactory.createEmptyBorder(2 * n, 2 * n, n, n);
        return BorderFactory.createCompoundBorder(border, border2);
    }
}

