/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.exec;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import org.ariane.tools.Resources;
import org.ariane.tools.ToolBox;

public class RunnerBar
extends Canvas
implements Runnable {
    private static final String BAR = "RunnerBar";
    private int nb;
    private int dw;
    private int ps;
    private boolean forth;
    private boolean running = false;
    private Thread thread = null;
    private int priority = 1;
    private long laps = 1000L;

    public RunnerBar(int n, int n2) {
        this.build(n, n2, 10);
    }

    public RunnerBar() {
        Resources resources = Resources.instance();
        this.priority = resources.get("RunnerBar.Priority", 1);
        this.laps = resources.get("RunnerBar.IdleTime", 2000);
        int n = resources.get("RunnerBar.StepsNumber", 10);
        int n2 = resources.get("RunnerBar.Width", 100);
        int n3 = resources.get("RunnerBar.Height", 3);
        this.build(n2, n3, n);
    }

    private void build(int n, int n2, int n3) {
        this.nb = n3 > 1 ? n3 : 2;
        this.ps = 0;
        this.forth = true;
        this.setSize(n, n2);
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        this.dw = n3 / this.nb;
        if (this.dw < 2) {
            this.dw = 2;
        }
        super.setBounds(n, n2, this.dw * this.nb, n4);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getForeground());
        graphics.fillRect(this.ps, 0, this.dw, dimension.height);
    }

    public synchronized void start() {
        this.start(null);
    }

    public synchronized void start(ThreadGroup threadGroup) {
        if (this.thread != null && this.thread.isAlive()) {
            if (ToolBox.verbose) {
                ToolBox.warn("RunnerBar already alive");
            }
            return;
        }
        this.ps = 0;
        this.running = true;
        this.forth = true;
        this.thread = threadGroup == null ? new Thread(this) : new Thread(threadGroup, this);
        this.thread.setPriority(this.priority);
        if (ToolBox.debug) {
            ToolBox.warn("RunnerBar started");
        }
        this.thread.start();
    }

    public synchronized void stop() {
        if (this.thread == null || !this.thread.isAlive()) {
            if (ToolBox.verbose) {
                ToolBox.warn("RunnerBar already dead");
            }
            return;
        }
        this.ps = -this.dw;
        this.forth = true;
        this.running = false;
        this.thread = null;
        if (ToolBox.debug) {
            ToolBox.warn("RunnerBar stopped");
        }
        this.repaint();
    }

    public void run() {
        Dimension dimension = this.getSize();
        int n = dimension.width - this.dw;
        int n2 = this.dw;
        try {
            while (this.running) {
                if (this.forth) {
                    this.ps += this.dw;
                    if (this.ps >= n) {
                        this.forth = false;
                    }
                } else {
                    this.ps -= this.dw;
                    if (this.ps < n2) {
                        this.forth = true;
                    }
                }
                this.repaint();
                Thread.sleep(this.laps);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.thread != null ? this.thread.toString() : "dead";
    }
}

