/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.exec;

import org.ariane.tools.Nobject;
import org.ariane.tools.ToolBox;

public abstract class RunnableTask
extends Nobject
implements Runnable {
    protected boolean done = false;
    private Thread thread = null;

    public RunnableTask(String string) {
        super(string);
    }

    public RunnableTask() {
        super("Task");
    }

    public final Thread getThread() {
        return this.thread;
    }

    public void start() {
        if (this.thread != null && this.thread.isAlive()) {
            if (ToolBox.debug) {
                ToolBox.warn("Task already alive");
            }
            return;
        }
        try {
            this.done = false;
            this.thread = new Thread((Runnable)this, this.getName());
            this.thread.start();
        }
        catch (Exception exception) {
            ToolBox.warn("Can't start " + this.getName(), exception);
            this.thread = null;
            this.done = true;
        }
    }

    public void start(ThreadGroup threadGroup) {
        if (this.thread != null && this.thread.isAlive()) {
            if (ToolBox.debug) {
                ToolBox.warn("Task already alive");
            }
            return;
        }
        try {
            this.done = false;
            this.thread = new Thread(threadGroup, this, this.getName());
            this.thread.start();
        }
        catch (Exception exception) {
            ToolBox.warn("Can't start " + this.getName(), exception);
            this.thread = null;
            this.done = true;
        }
    }

    public void stop() {
        if (this.thread == null || !this.thread.isAlive()) {
            return;
        }
        this.done = true;
        this.thread = null;
    }

    public final ThreadGroup getGroup() {
        if (this.thread == null) {
            return null;
        }
        return this.thread.getThreadGroup();
    }

    public final void setPriority(int n) {
        block3: {
            try {
                if (this.thread != null) {
                    this.thread.setPriority(n);
                }
            }
            catch (Exception exception) {
                if (!ToolBox.debug) break block3;
                ToolBox.warn("Can't set priority", exception);
            }
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public String toString() {
        return this.thread != null ? this.thread.toString() : "dead";
    }

    public abstract void run();
}

