/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JLabel;
import org.ariane.tools.Resources;
import org.ariane.tools.ToolBox;

public class WebForm
extends Applet {
    public static final int SPACE = 4;
    protected GridBagLayout grid;
    protected GridBagConstraints cons;
    protected JLabel msgline;
    protected Resources resources;
    protected boolean onweb = true;
    private static final String WEBFORM = "WebForm.";

    public WebForm() {
    }

    public WebForm(boolean bl) {
        this.onweb = bl;
    }

    public void init(String string) {
        this.setMode();
        if (ToolBox.debug) {
            ToolBox.warn("Initializing " + (string == null ? "WebForm" : string));
        }
        String string2 = this.getLibDirectory();
        String string3 = null;
        if (string2 != null && string2.endsWith("lib")) {
            string3 = string2.substring(0, string2.length() - 4);
        }
        if (string3 != null && System.getProperty("jvs.home") == null) {
            if (ToolBox.debug) {
                ToolBox.warn("JVS home set from applet archive parameter " + string3);
            }
            System.setProperty("jvs.home", string3);
        }
        this.resources = Resources.instance();
        if (string != null) {
            this.resources.load();
        }
        this.setMode();
        this.setBackground();
        this.setDefaultFont();
        this.grid = new GridBagLayout();
        this.cons = new GridBagConstraints();
        this.setLayout(this.grid);
        if (string == null) {
            return;
        }
        this.displayTitle(string);
        Component component = Box.createGlue();
        this.grid.setConstraints(component, this.cons);
        this.add(component);
    }

    private final String getLibDirectory() {
        if (!this.onweb) {
            return null;
        }
        String string = this.getParameter("ARCHIVE");
        if (string == null) {
            if (ToolBox.debug) {
                ToolBox.warn("Can't find ARCHIVE value");
            }
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("jvs.jar");
            if (n <= 0) continue;
            return string2.substring(0, n - 1);
        }
        if (ToolBox.debug) {
            ToolBox.warn("JVS lib not found in " + string);
        }
        return null;
    }

    private final void setMode() {
        if (!this.onweb) {
            return;
        }
        String string = this.getParameter("MODE");
        if (string == null) {
            ToolBox.verbose = false;
            ToolBox.debug = false;
            return;
        }
        if (string.equalsIgnoreCase("verbose")) {
            ToolBox.verbose = true;
            ToolBox.debug = false;
        } else if (string.equalsIgnoreCase("debug")) {
            ToolBox.verbose = true;
            ToolBox.debug = true;
        } else if (string.equalsIgnoreCase("quiet")) {
            ToolBox.verbose = false;
            ToolBox.debug = false;
        } else {
            ToolBox.verbose = true;
            ToolBox.debug = false;
            this.warn("Unknown mode : " + string);
        }
    }

    private void displayTitle(String string) {
        if (string == null) {
            return;
        }
        JLabel jLabel = new JLabel(string);
        this.cons.insets = new Insets(8, 0, 0, 0);
        this.cons.weightx = 1.0;
        this.cons.anchor = 10;
        this.cons.gridwidth = 0;
        this.grid.setConstraints(jLabel, this.cons);
        Font font = this.resources.get("WebForm.Title.Font", "Helvetica", 1, 16);
        jLabel.setFont(font);
        this.add(jLabel);
    }

    protected void addMessageLine() {
        this.msgline = new JLabel("Applet initialized !");
        Font font = this.resources.get("WebForm.Message.Font", "Times", 2, 14);
        this.msgline.setFont(font);
        this.msgline.setBackground(this.resources.get("WebForm.Message.Background", Color.cyan));
        this.msgline.setForeground(this.resources.get("WebForm.Message.Foreground", Color.black));
        this.cons.gridwidth = 0;
        this.grid.setConstraints(this.msgline, this.cons);
        this.add(this.msgline);
    }

    public final void sendMessage(String string) {
        if (this.msgline != null) {
            this.msgline.setText(string + " !");
        }
    }

    public final void clearMessage() {
        if (this.msgline != null) {
            this.msgline.setText("");
        }
    }

    private final void setBackground() {
        Color color = this.resources.get("WebForm.Background", (Color)null);
        if (color == null) {
            return;
        }
        this.setBackground(color);
    }

    private final void setDefaultFont() {
        Font font = new Font("SansSerif", 0, 14);
        this.setFont(font);
    }

    private final GridBagConstraints getConstraints() {
        return this.cons;
    }

    public final void warn(String string, Exception exception) {
        String string2 = string + " : " + exception + " !";
        if (this.onweb) {
            this.showStatus(string2);
        }
        if (ToolBox.verbose) {
            System.err.println(string2);
        }
    }

    public final void warn(String string) {
        String string2 = string + " !";
        if (this.onweb) {
            this.showStatus(string2);
        }
        if (ToolBox.verbose) {
            System.err.println(string2);
        }
    }
}

