/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.applet;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.ariane.exec.RunnableTask;

public class RunnerBar
extends JProgressBar {
    private Timer timer;
    private RunnableTask task;
    private boolean up;
    private int period = 1000;

    public RunnerBar() {
        this.setMinimum(0);
        this.setStringPainted(false);
        this.setValue(this.getMinimum());
        this.setOrientation(0);
    }

    public final void setPeriod(int n) {
        this.period = n;
    }

    public void start(RunnableTask runnableTask) {
        this.task = runnableTask;
        this.up = true;
        if (this.timer == null) {
            this.createTimer();
        }
        this.timer.start();
    }

    private void createTimer() {
        this.timer = new Timer(this.period, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RunnerBar.this.task.isDone()) {
                    RunnerBar.this.timer.stop();
                    RunnerBar.this.setValue(RunnerBar.this.getMinimum());
                    RunnerBar.this.task = null;
                    return;
                }
                int n = RunnerBar.this.getValue();
                if (RunnerBar.this.up) {
                    if (n >= RunnerBar.this.getMaximum()) {
                        --n;
                        RunnerBar.this.up = false;
                    } else {
                        ++n;
                    }
                } else if (n <= RunnerBar.this.getMinimum()) {
                    ++n;
                    RunnerBar.this.up = true;
                } else {
                    --n;
                }
                RunnerBar.this.setValue(n);
            }
        });
    }
}

