/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.applet;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.URL;
import org.ariane.tools.ToolBox;

public class Picture
extends Canvas {
    private Image image;
    private int id;
    private MediaTracker tracker;
    private int border = 1;

    public Picture(String string) {
        boolean bl;
        boolean bl2 = bl = string.indexOf("://") >= 0;
        if (bl) {
            try {
                this.loadImage(new URL(string));
            }
            catch (Exception exception) {
                this.tracker = new MediaTracker(this);
                this.image = null;
            }
        } else {
            this.loadImage(string);
        }
    }

    public Picture(URL uRL) {
        this.loadImage(uRL);
    }

    public Picture() {
        this.image = null;
        this.tracker = null;
    }

    public final void refresh() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            ((Component)this).update(graphics);
        }
    }

    public final void doLoad() {
        try {
            this.tracker.waitForID(this.id);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setSize(this.getPreferredSize());
    }

    public final Dimension imageSize() {
        int n = this.image.getWidth(this);
        int n2 = this.image.getHeight(this);
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        int n = this.image.getWidth(this) + 2 * this.border;
        int n2 = this.image.getHeight(this) + 2 * this.border;
        return new Dimension(n, n2);
    }

    public final boolean isLoaded() {
        return (this.tracker.statusID(this.id, true) & 8) != 0;
    }

    public final boolean hasFailed() {
        return this.tracker.isErrorID(this.id);
    }

    public final void setBorderWidth(int n) {
        this.border = n;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.border > 0) {
            graphics.setColor(this.getForeground());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
        if (this.image == null) {
            return;
        }
        int n = this.tracker.statusID(this.id, true);
        if ((n & 4) != 0) {
            ToolBox.warn("Image in error");
            return;
        }
        if ((n & 2) != 0) {
            ToolBox.warn("Image aborted");
            return;
        }
        if ((n & 1) != 0) {
            graphics.drawString("Loading ...", dimension.width / 2 - 10, dimension.height / 2);
            return;
        }
        if ((n & 8) != 0 && ToolBox.debug) {
            ToolBox.warn("Image complete");
        }
        if (ToolBox.debug) {
            System.out.println(this.imageSize().toString());
        }
        graphics.drawImage(this.image, this.border, this.border, this);
    }

    public void loadImage(Object object) {
        if (this.tracker != null) {
            return;
        }
        this.getImage(object);
        this.id = 0;
        this.tracker = new MediaTracker(this);
        this.tracker.addImage(this.image, this.id);
    }

    private void getImage(Object object) {
        if (this.image != null) {
            return;
        }
        if (object instanceof String) {
            this.image = this.getToolkit().getImage((String)object);
        } else if (object instanceof URL) {
            ToolBox.warn("Get Image from URL " + ((URL)object).toString());
            this.image = this.getToolkit().getImage((URL)object);
        }
    }
}

