/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.applet;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import org.ariane.applet.Gadget;

public class LabelGadget
extends Gadget {
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    public static final int CENTER = 1;
    private int alignment;
    private int margin = 2;
    private String label;

    public LabelGadget(Component component, String string, int n) {
        super(component);
        if (n != 2 && n != 1 && n != 0) {
            n = 0;
        }
        this.alignment = n;
        if (string != null) {
            this.label = new String(string);
        }
        this.font = new Font("Helvetica", 0, 16);
    }

    public LabelGadget(Component component) {
        this(component, null, 1);
    }

    public final void realize() {
        this.setGeometry();
    }

    public final void setLabel(String string) {
        this.label = new String(string);
        this.setGeometry();
    }

    private final void setAlignment(int n) {
        if (n != 2 && n != 1 && n != 0) {
            n = 0;
        }
        this.alignment = n;
        this.setGeometry();
    }

    private void setGeometry() {
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        if (fontMetrics == null) {
            this.resize(this.margin, this.margin);
            this.setReference(0, 0);
            return;
        }
        int n = 2 * this.margin + fontMetrics.getHeight();
        int n2 = 2 * this.margin;
        if (this.label != null) {
            n2 += fontMetrics.stringWidth(this.label);
        }
        int n3 = this.margin + fontMetrics.getMaxAscent();
        int n4 = this.margin;
        switch (this.alignment) {
            case 0: {
                n4 = this.margin;
                break;
            }
            case 2: {
                n4 = n2 - this.margin;
                break;
            }
            case 1: {
                n4 = n2 / 2;
            }
        }
        this.resize(n2, n);
        this.setReference(n4, n3);
    }

    public void draw(Graphics graphics) {
        if (this.label == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        if (fontMetrics == null) {
            return;
        }
        int n = 2 * this.margin + fontMetrics.stringWidth(this.label);
        Point point = this.reference();
        switch (this.alignment) {
            case 2: {
                point.x -= n;
                break;
            }
            case 1: {
                point.x -= n / 2;
            }
        }
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        this.drawString(graphics, this.label, point.x, point.y);
    }
}

