/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.applet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.ariane.tools.Resources;
import org.ariane.tools.ToolBox;

public class HelpWindow
extends Frame
implements ActionListener {
    private static HelpWindow window = null;
    private static final String CLOSE = "C";
    private JLabel title;
    private JTextArea area;
    private String prefix;

    public static HelpWindow instance() {
        if (window == null) {
            window = new HelpWindow(null);
        }
        return window;
    }

    public static HelpWindow create(String string) {
        if (window == null) {
            window = new HelpWindow(string);
        }
        return window;
    }

    private HelpWindow(String string) {
        this.prefix = string == null ? new String("HelpWindow") : string + ".Help";
        Resources resources = Resources.instance();
        this.setTitle("Help Window");
        ((Component)this).setBackground(resources.get(this.prefix + ".Background", Color.white));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 0;
        this.setLayout(gridBagLayout);
        Font font = resources.get(this.prefix + ".Header.Font", "SansSerif", 1, 14);
        this.title = new JLabel("Help Window");
        this.title.setFont(font);
        gridBagLayout.setConstraints(this.title, gridBagConstraints);
        this.add(this.title);
        font = resources.get(this.prefix + ".Text.Font", "Serif", 0, 14);
        int n = resources.get(this.prefix + ".ColumnS", 20);
        int n2 = resources.get(this.prefix + ".Rows", 10);
        this.area = new JTextArea("", n2, n);
        this.area.setEditable(false);
        this.area.setFont(font);
        gridBagLayout.setConstraints(this.area, gridBagConstraints);
        this.add(this.area);
        JButton jButton = new JButton("Close");
        jButton.setFont(font);
        jButton.setActionCommand(CLOSE);
        jButton.addActionListener(this);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        int n3 = resources.get(this.prefix + ".Width", 200);
        int n4 = resources.get(this.prefix + ".Height", 200);
        ((Component)this).setSize(n3, n4);
    }

    public void display(String string, String string2) {
        if (ToolBox.debug) {
            ToolBox.warn("Displaying help " + string);
        }
        this.title.setText(string);
        this.area.setText(string2);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(CLOSE)) {
            ((Component)this).setVisible(false);
        }
    }
}

