/*
 * Decompiled with CFR 0.152.
 */
package org.ariane.applet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class Gadget {
    int x;
    int y;
    protected int s;
    protected int t;
    int width;
    int height;
    int border_width = 0;
    protected Font font;
    protected Color foreground = Color.black;
    protected Component parent;

    public Gadget(Component component) {
        this.parent = component;
    }

    public abstract void draw(Graphics var1);

    public Point location() {
        return new Point(this.x, this.y);
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setReference(int n, int n2) {
        this.s = n;
        this.t = n2;
    }

    public void move(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void move(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public Component getParent() {
        return this.parent;
    }

    public Font getFont() {
        return this.font;
    }

    public int getFontHeight() {
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        return fontMetrics == null ? 10 : fontMetrics.getHeight();
    }

    public int getFontAscent() {
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        return fontMetrics == null ? 5 : fontMetrics.getAscent();
    }

    public int getStringWidth(String string) {
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        return fontMetrics == null ? 10 : fontMetrics.stringWidth(string);
    }

    public void realize() {
    }

    public FontMetrics getFontMetrics(Font font) {
        try {
            return this.parent.getFontMetrics(font);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Color getBackground() {
        return this.parent.getBackground();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    protected void drawBorder(Graphics graphics) {
        if (this.border_width > 0) {
            graphics.drawRect(this.x, this.y, this.width, this.height);
        }
    }

    public void setBorderWidth(int n) {
        this.border_width = n;
    }

    protected void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(this.x + n, this.y + n2, this.x + n3, this.y + n4);
    }

    protected void drawString(Graphics graphics, String string, int n, int n2) {
        graphics.drawString(string, this.x + n, this.y + n2);
    }

    public Point reference() {
        return new Point(this.s, this.t);
    }

    public void pinAt(Point point) {
        this.pinAt(point.x, point.y);
    }

    public void pinAt(int n, int n2) {
        this.move(n - this.s, n2 - this.t);
    }

    public String toString() {
        return "Gadget width : " + this.width + " height : " + this.height + " x : " + this.x + " y : " + this.y + " s : " + this.s + " t : " + this.t;
    }
}

