/*
 * FILE: webopts.h
 *
 * FUNCTION:
 * Parse webbot/webclient command-line arguments.
 *
 * DESIGN NOTES:
 * Should be updated with a unified command-line/config-file utility.
 *
 * HISTORY:
 * created by Linas Vepstas June 1998
 */

#ifndef __WEBOPTS_H__
#define __WEBOPTS_H__

#include <stdio.h>

#include "cookie.h"
#include "socket.h"
#include "super.h"
#include "sysdep.h"


#define DEFAULTWWWPORT 80
#define DEFAULTHTTPSPORT 443

// This stucture contains global config data.
// Most of these fields are documented elsewhere ... 


// Note about the size of flags: e.g. fetch_gifs: these should be ints
// and not changed to short or char even though short or char can
// hold the desired value.  This is because the command line option
// parsing code expects (pointers to) ints, and on a big-endian 
// machine, the LSB's don't match: *((short *)ptr) != *((long *) ptr) 

class wlOpts {
   public:
      wlOpts (void);
      ~wlOpts ();
      void     ParseArgs (int *argc, char *argv[]);
      int      ProcessOpts (void);
      void     PrintOptionsSummary (void);
      void     CloseFiles (void);

   public:
      char    *progname;
      wlString version;
      int      argc;
      char   **argv;
   
      wlString webserver;
      NETPORT  web_portnum;
      wlString proxyserver;
      NETPORT  proxy_portnum;
   
      char    *local_fqdn_host_name;
      char    *local_host_name;
      NETPORT  local_portnum;
   
      wlString user_agent_name;
      wlString header;

      int      protocol_minor_version;   /* 0 for 1.0, 1 for 1.1 */
      wlString http_version;   /* HTTP/1.0 or 1.1, consistent with above */
      int      keep_alive;     /* use keep-alive sockets to get gifs  */
      int      alarm_time;
      int      fetch_gifs;
      int      do_cache_emulation;  /* emulate gif cache */
      int      nthreads;       /* number of threads to use to get gifs */
      int      print_each;
      int      ignore_checksum_errors;
      int      warn_checksum_errors;
      int      wait_interval;
      int      skip_stats;     /* equals 1 if we don't bother with stats */
      int      do_host_translation;
      int      act_as_proxy;
      int      trace_server;
      int      trace_client;
   
      int      debug;
      int      tdebug;
      int      quiet_stdout;
      int      write_completion_times;
      int      write_url_progress;
      int      run_in_background;  /* not available on win32 */
      int      prt_version;
      int      seed;
      int      num_sessions;
      int      bug_compat;

      int      think_distribution;
      double   mean_think_time;
      enum {THINK_FIXED, THINK_EXPONENTIAL, THINK_GAUSSIAN };

   
      // input files 
      char    *clean_exit_file_name;
      char    *header_file_name;
      char    *input_file_name;

      // output files
      char    *access_log_file_name;
      char    *error_log_file_name;
      char    *report_file_name;
      char    *trace_file_name;
      char    *url_out_file_name;
   
      FILE    *access_log_file;
      FILE    *url_out_file;
      FILE    *report_file;
      FILE    *trace_file;
      FILE    *error_log_file;
      int      error_log;      /* file descriptor */
   
      /* arrays of values and key-value pairs */
      wlCache  path_requires_cookie;

      char   **substitution_key;
      char   **substitution_value;
      char   **header_subst_field;
      char   **header_subst_value;
      char   **header_add_field;
      char   **header_add_value;

      // XXX hack alert -- in order to be multi-threaded, we need
      // to track the handles in a per-session object, and not here.
      char   **handle_field;
      char   **handle_value;

 
      // Note that WIN32 does not support shared memory, and that
      // these fields will always be zero for this OS.
      int     child_number;
      int     shm_key;
      int    *shm_base; 

      wlSSLInfo client_ssl_opts;
      wlSSLInfo server_ssl_opts;

};

#endif /* __WEBOPTS_H__ */
/* ========================== END OF FILE ====================== */
