/**************************************************************************
 *									  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs were	  *
 *  developed by SGI for public use.  If any changes are made to this code*
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modifications and changes to the code and release it.		  *
 *									  *
 **************************************************************************/

#include "sysdep.h"
/* strerror() */
#ifndef HAVE_STRERROR
/* strerror is not available on SunOS 4.1.3 and others */
extern int sys_nerr;
extern char *sys_errlist[];
extern int errno;

char *strerror(int errnum)
{ 

    if (errnum<sys_nerr)
    {
	return(sys_errlist[errnum]);
    }

    return(NULL);
}

#endif /* strerror() */


/* stub routines for NT */ 

#ifdef NOTDEF
#ifdef WIN32
#include <winsock.h>
#include <process.h>

int getpid(void) {

    return GetCurrentThreadId();
}

#endif /* WIN32 */
#endif

#ifdef OTHER_UNIX

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

/* implementation of really slow atomic spinklock 
 * to update value stored in shared-memory.
 */

#define LOCK_PATH "/tmp/webload.LCK"
int
fetch_and_add (int *loc, int val) 
{
	int retval;
	/* spinlock */
	retval = open (LOCK_PATH, O_CREAT |O_EXCL | O_RDWR);

    while ((-1 == retval) && (EEXIST == errno)) {
		retval = open (LOCK_PATH, O_CREAT |O_EXCL | O_RDWR);
    }
	if (-1 == retval) {
		int norr = errno;
		printf ("lock failed, errno=%d %s\n", norr, strerror (norr));
		exit (1);
	}
	*loc += val;
	close (retval);
	unlink (LOCK_PATH);
	return 0;
}


#endif /* OTHER_UNIX */
