//
// class wlString
//
// FUNCTION:
// Implements a string class that provides somewhat more efficient 
// and pwerful string handling abilities than the usual java and c++
// string classes.
//

#include <stdio.h>
#include <string.h>
#include "super.h"

/* ========================================================== */

wlString :: wlString (void)
{
   head = NULL;
   tail = NULL;
}

wlString :: wlString (const char *inp)
{
   head = tail = NULL;
   Strcat (inp);
}

wlString :: wlString (wlString &ref)
{
   head = tail = NULL;
   Memcat (ref);
}

/* ========================================================== */

void
wlString :: gitgone (void)
{
   Chunk *cursor = head;
   while (cursor) {
      char * str = cursor->root;
      Chunk *dup = cursor;
      
      if (str) {
         // look for memory blocks that occur in multiple chunks
         while (dup) {
            if (str == dup->root) dup->root = NULL;
            dup = dup->next;
         }
   
         // free the string memory
         delete [] str;
      }

      // delete this chunk
      Chunk *fc = cursor;
      cursor = cursor->next;
      delete fc;
   }
   head = tail = NULL;
}

/* ========================================================== */

wlString :: ~wlString ()
{
   gitgone ();
}

/* ========================================================== */

wlString :: operator char * ()
{
   defrag();
   if (!head) return 0x0;
   return (head->start);
}

wlString &
wlString :: operator= (const char *ptr)
{
   Strcpy (ptr);
   return *this;
}

wlString &
wlString :: operator+= (const char *ptr)
{
   Strcat (ptr);
   return *this;
}

wlString &
wlString :: operator= (const wlString &ref)
{
   Memcpy ((wlString&) ref);
   return *this;
}

wlString &
wlString :: operator+= (const wlString &ref)
{
   Memcat ((wlString&) ref);
   return *this;
}

/* ========================================================== */

size_t
wlString :: Memlen (void) const
{
   size_t len = 0;
   Chunk *cursor = head;
   while (cursor) {
      len += cursor->len;
      cursor = cursor->next;
   }

   return len;
}


/* ========================================================== */

void 
wlString :: PutIn (char *inp, size_t lenny)
{
   if (!inp) return;

   Chunk *s = new Chunk;
   s->next = NULL;
  
   s->len = lenny;
   s->root = inp;
   s->start = inp;

   if (!tail) {
      head = s;
   } else {
      tail->next = s;
   }
   tail = s;
}

void 
wlString :: Strcat (const char *inp)
{
   if (!inp) return;
   size_t lenny = strlen (inp);
   Memcat (inp, lenny);
}

void 
wlString :: Memcat (const char *inp, size_t len)
{
   if (!inp) return;

   Chunk *s = new Chunk;
   s->next = NULL;
  
   s->len = len;
   s->root = new char [(len +1)];
   s->start = s->root;

   memcpy (s->start, inp, len);   
   s->start[len] = '\0';

   if (!tail) {
      head = s;
   } else {
      tail->next = s;
   }
   tail = s;
}

void 
wlString :: Memcat (wlString &ref)
{
   ref.defrag();
   if (!ref.head) return;
   Memcat (ref.head->start, ref.head->len);
}

/* ========================================================== */

void
wlString :: Strcpy (const char *inp)
{
   gitgone ();
   Strcat (inp);
}

void
wlString :: Memcpy (const char *inp, size_t len)
{
   gitgone ();
   Memcat (inp, len);
}

void
wlString :: Memcpy (wlString &ref)
{
   gitgone ();
   Memcat (ref);
}

/* ========================================================== */

void
wlString :: defrag (void) 
{
   if (!head) return;

   // if not fragmented, do nothing
   if (NULL == head->next) return;

   // otherwise malloc a single continuous block of memory
   Chunk *s = new Chunk;
   s->next = NULL;
  
   s->len = Memlen();
   char * ptr = new char [(s->len +1)];
   s->root = ptr;
   s->start = ptr;

   // copy from fragments into the new mem block
   Chunk *cursor = head;
   while (cursor) {
      if (0 < cursor->len) {
         memcpy (ptr, cursor->start, cursor->len);
         ptr += cursor->len;
      }
      cursor = cursor->next;
   }
   *ptr = '\0';  // null terminate strings 

   // blow away the old memory
   gitgone ();
   head = s;
   tail = s;
}

/* ========================================================== */

int
wlString :: Substitute (const char *from, const char *to)
{
   if (!from) return 0;
   defrag ();
   int count = subs (from, to);
   return count;
}

int
wlString :: SubMulti (char **from, char **to)
{
   if (!from) return 0;

   defrag ();
   int count = 0;
   int i=0;
   while (from[i]) {
      count += subs (from[i], to[i]);
      i++;
   }
   return count;
}

/* ========================================================== */

wlString::Chunk *
wlString :: subsone (Chunk * cursor, 
                     char * begin, 
                     size_t fromlen,
                     char * tutu, 
                     size_t tolen)
{
   // terminate the string
   size_t oldlen = cursor->len;
   cursor->len = begin - cursor->start;
   *(cursor->start + cursor->len) = '\0';

   // put the tail end of the text in a separate chunk
   Chunk * rem = new Chunk;
   rem->root = cursor->root;
   size_t remoffset = cursor->len + fromlen;
   rem->start = cursor->start + remoffset;
   rem->len = oldlen - remoffset;

   // if there is something to insert, then insert it
   if (0 < tolen) 
   { 
      // insert the new text
      Chunk * splice = new Chunk;
      splice->root  = tutu;
      splice->start = tutu;
      splice->len   = tolen;
   
      // chain them all together
      rem->next = cursor->next;
      splice->next  = rem;
      cursor->next = splice;
   }
   else
   {
      // nothing to insert.  We just deleted text from the middle.
      rem->next = cursor->next;
      cursor->next = rem;
   }

   // get ready to iterate again
   return cursor->next;
}

/* ========================================================== */

int
wlString :: subs (const char * from, const char * to)
{
   if (!from || !to) return 0;

   size_t fromlen = strlen (from);

   // assume that we will indeed make a substitution
   size_t tolen = strlen (to);
   char * tutu = new char [(tolen+1)];
   strcpy (tutu, to);

   // begin searching for the needle in the haystack
   int count = 0;
   Chunk *cursor = head;
   while (cursor) {
      char * begin = strstr (cursor->start, from);
      if (begin) {
         count ++;
         cursor = subsone (cursor, begin, fromlen, tutu, tolen);
      }
      cursor = cursor->next;
   }

   if (0 == count) {
      delete [] tutu;
   }

   return count;
}

/* ========================================================== */

