
/**************************************************************************
 *                                                                        *
 *               Copyright (C) 1995 Silicon Graphics, Inc.                *
 *                                                                        *
 *  These coded instructions, statements, and computer programs were      *
 *  developed by SGI for public use.  If any changes are made to this code*
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modifications and changes to the code and release it.                 *
 *                                                                        *
 **************************************************************************/
#ifndef __WL_STATS_H__ 
#define __WL_STATS_H__

#include "timefunc.h"

/* ================================================================== */
/* ================================================================== */
/* ================================================================== */
/* ================================================================== */

typedef struct request_size {
    unsigned int   bytessent;       /* number of plaintext (unencrypted) bytes sent... */
    unsigned int   netbytessent;    /* total bytes sent by network layer ............. */
    unsigned int   bytesread;       /* number of plaintext (decrypted) bytes read. ... */
    unsigned int   netbytesread;    /* total number of network bytes xferred. ........ */
    unsigned int   headbytes;       /* number of plaintext header bytes read. ........ */
    unsigned int   bodybytes;       /* number of plaintext body bytes read. .......... */
} request_size_t;


#define INIT_RQSIZE(rqsize) {		\
    (rqsize) . bytessent = 0;		\
    (rqsize) . netbytessent = 0;	\
    (rqsize) . bytesread = 0;		\
    (rqsize) . netbytesread = 0;	\
    (rqsize) . headbytes = 0;		\
    (rqsize) . bodybytes = 0;		\
}

#define ACCUM_RQSIZE(acc,rqsize) {				\
    (acc) . bytessent    += (rqsize) . bytessent;		\
    (acc) . netbytessent += (rqsize) . netbytessent;		\
    (acc) . bytesread    += (rqsize) . bytesread;		\
    (acc) . netbytesread += (rqsize) . netbytesread;		\
    (acc) . headbytes    += (rqsize) . headbytes;		\
    (acc) . bodybytes    += (rqsize) . bodybytes;		\
}


/* ================================================================== */
/* ================================================================== */
/* ================================================================== */
/* ================================================================== */

/* NPTIMER_TIME_STRUCT MUST be one less than the number of 
 * time_structs in the page_timer structure. 
 */
#define NPTIMER_TIME_STRUCT 33

class wlPageTimer 
{
    public:
        wlPageTimer (void);
        void Clear (void);

        // it is imperitive that the time_struct's are all together 
        // with no other record mixed in between (we use an array to 
        // reference these things)

        time_struct     getpage_entry;          /* when getpage startd. ....................... */
        time_struct     getpage_exit;           /* when getpage ended. (before timer stats calc)*/
        time_struct     getpage_time;           /* total time in getpage. ..................... */
        time_struct     sum_of_getpage_overhead;/* overhead time spent in getpage. ............ */
        time_struct     sum_of_response_times;  /* how long it took to get entire page. ....... */
        time_struct     sum_of_connect_times;   /* sum of connect times this page. ............ */
        time_struct     sum_of_header_delays;   /* sum of header delays this page. ............ */
        time_struct     sum_of_transfer_times;  /* sum of body transfer times. ................ */
        time_struct     sum_of_get_times;       /* sum of times spent in get subroutine ....... */
        time_struct     sum_of_get_overhead_times; /* sum of overhead times in get subroutine.. */
        time_struct     sum_of_html_get_times;  /* sum of times in get routine for html files.. */
        time_struct     sum_of_html_ovhd_times; /* sum of overhead times in get for html files. */
        time_struct     sum_of_html_response_times; /* sum of html response times. ............ */
        time_struct     sum_of_gif_get_times;   /* sum of times in get routine for gif files... */
        time_struct     sum_of_gif_ovhd_times;  /* sum of overhead times in get for gif files.. */
        time_struct     sum_of_gif_response_times; /* sum of gif response times. .............. */
        time_struct     first_data_response_time;/* connect time of first page to first packet  */
                                                 /* of data on final html page. ............... */
        time_struct     sum_of_tcp_connect_times;/* sum of time spent in tcp in connectsock.... */
        time_struct     sum_of_ssl_connect_ovhd; /* sum of time spent in SSL in connectsock.... */
        time_struct     sum_of_ssl_net_delay_connect; /* net+server delay during SSL connect... */
        time_struct     sum_of_ssl_header_ovhd;  /* sum of time spent in ssl for header. ...... */
        time_struct     sum_of_ssl_net_delay_header; /* net+server delay waiting for header.... */
        time_struct     sum_of_ssl_transfer_ovhd;/* sum of time spent in ssl xferring body..... */
        time_struct     sum_of_ssl_net_delay_transfer; /* net+server time spent xferring body.. */
        time_struct     sum_of_html_net_delay;   /* time spent in READ/WRITE getting html...... */
        time_struct     sum_of_gif_net_delay;    /* time spent in READ/WRITE getting gifs...... */
        time_struct     sum_of_net_delay;        /* time spent in READ/WRITE getting page...... */
        time_struct     sum_of_html_ssl_ovhd;    /* time spent in SSL encryption getting html.. */
        time_struct     sum_of_gif_ssl_ovhd;     /* time spent in SSL encryption getting gifs.. */
        time_struct     sum_of_ssl_ovhd;         /* time spent in SSL encryption getting page.. */
        time_struct     end_to_end_time;         /* should equal getpage_time to within usecs.  */
        time_struct     think_time;              /* pause after page  ......................... */
        time_struct     request_time;            /* time to handle request plus think time..... */

        static char*    timer_names[NPTIMER_TIME_STRUCT];

        int             number_of_redirects;    /* the number of redirections for this page.... */
        int             number_of_connects;     /* total num connects over all files this page. */
        int             number_of_conn_reuses;  /* total num reused keep-alive connections. ... */
        int             number_of_reuse_fails;  /* total num reused keep-alive sockets died. .. */
        int             num_gifs_fetched;       /* number of gif files fetched. ............... */
        int             num_gifs_cached;        /* number of gif files aken from cache. ....... */
    
        request_size_t  setup;                  /* setup = html on redirect pages ............. */
        request_size_t  last;                   /* last = html (not gifs) on last page .........*/
        request_size_t  gif;                    /* gif = gifs on last page .................... */

};

#define DCL_STATS(FOO) sub_stats_t FOO;

#define OBS_STATS(STATS,NAME,PTIMER) {\
	double tmpdbl = timevaldouble(&(PTIMER.sum_of_##NAME));\
	if ((opts.report_file) && (opts.print_each)) \
		fprintf((opts.report_file),"TPUT <OBS>   try=%d req=%d trial=%d datum = " #NAME "\tvalue=%10.6f\n",STATS.NAME.count,this_request,trial,tmpdbl);\
	STATS.NAME.last_val = tmpdbl;\
	STATS.NAME.sum += tmpdbl;\
	STATS.NAME.sumsq += tmpdbl*tmpdbl;\
	if (STATS.NAME.min > tmpdbl) {\
		STATS.NAME.min = tmpdbl; \
		STATS.NAME.min_try = STATS.NAME.count; \
		STATS.NAME.min_trial = trial; \
	}\
	if (STATS.NAME.max < tmpdbl) {\
		STATS.NAME.max = tmpdbl; \
		STATS.NAME.max_try = STATS.NAME.count; \
		STATS.NAME.max_trial = trial; \
	}\
	STATS.NAME.count++;\
}

/* we need this because first_data_response_time is not a sum_of_ statistic ...............*/
#define OBS_STATS1(STATS,NAME,PTIMER) {\
	double tmpdbl = timevaldouble(&(PTIMER.NAME));\
	if ((opts.report_file) && (opts.print_each)) \
		fprintf((opts.report_file),"TPUT <OBS>   try=%d req=%d trial=%d datum = " #NAME "\tvalue=%10.6f\n",STATS.NAME.count,this_request,trial,tmpdbl);\
	STATS.NAME.last_val = tmpdbl;\
	STATS.NAME.sum += tmpdbl;\
	STATS.NAME.sumsq += tmpdbl*tmpdbl;\
	if (STATS.NAME.min > tmpdbl) {\
		STATS.NAME.min = tmpdbl; \
		STATS.NAME.min_try = STATS.NAME.count; \
		STATS.NAME.min_trial = trial; \
	}\
	if (STATS.NAME.max < tmpdbl) {\
		STATS.NAME.max = tmpdbl; \
		STATS.NAME.max_try = STATS.NAME.count; \
		STATS.NAME.max_trial = trial; \
	}\
	STATS.NAME.count++;\
}

/* we need this version for the webclient special statistics. (do not reside in struct).... */
#define OBS_STATS2(STATS,NAME) {\
	double tmpdbl = timevaldouble(&NAME);\
	if ((opts.report_file) && (opts.print_each)) \
		fprintf((opts.report_file),"TPUT <OBS>   try=%d req=%d trial=%d datum = " #NAME "\tvalue=%10.6f\n",STATS.NAME.count,this_request,trial,tmpdbl);\
	STATS.NAME.last_val = tmpdbl;\
	STATS.NAME.sum += tmpdbl;\
	STATS.NAME.sumsq += tmpdbl*tmpdbl;\
	if (STATS.NAME.min > tmpdbl) {\
		STATS.NAME.min = tmpdbl; \
		STATS.NAME.min_try = STATS.NAME.count; \
		STATS.NAME.min_trial = trial; \
	}\
	if (STATS.NAME.max < tmpdbl) {\
		STATS.NAME.max = tmpdbl; \
		STATS.NAME.max_try = STATS.NAME.count; \
		STATS.NAME.max_trial = trial; \
	}\
	STATS.NAME.count++;\
}
/* we need this version for the webclient special statistics. (record simple value only)... */
#define OBS_STATS3(STATS,NAME,VALUE) {\
	double tmpdbl = VALUE;\
	if ((opts.report_file) && (opts.print_each)) \
		fprintf((opts.report_file),"TPUT <OBS>   try=%d req=%d trial=%d datum = " #NAME "\tvalue=%10.6f\n",STATS.NAME.count,this_request,trial, tmpdbl);\
	STATS.NAME.last_val = tmpdbl;\
	STATS.NAME.sum += tmpdbl;\
	STATS.NAME.sumsq += tmpdbl*tmpdbl;\
	if (STATS.NAME.min > tmpdbl) {\
		STATS.NAME.min = tmpdbl; \
		STATS.NAME.min_try = STATS.NAME.count; \
		STATS.NAME.min_trial = trial; \
	}\
	if (STATS.NAME.max < tmpdbl) {\
		STATS.NAME.max = tmpdbl; \
		STATS.NAME.max_try = STATS.NAME.count; \
		STATS.NAME.max_trial = trial; \
	}\
	STATS.NAME.count++;\
}

/* observe a value in a sub_stats_t ..................................*/
#define OBS_STATS_DBL(STATS,VALUE) {\
	double tmpdbl = VALUE;\
	STATS.last_val = tmpdbl;\
	STATS.sum += tmpdbl;\
	STATS.sumsq += tmpdbl*tmpdbl;\
	if (STATS.min > tmpdbl) {\
		STATS.min = tmpdbl; \
		STATS.min_try = STATS.count; \
		STATS.min_trial = trial; \
	}\
	if (STATS.max < tmpdbl) {\
		STATS.max = tmpdbl; \
		STATS.max_try = STATS.count; \
		STATS.max_trial = trial; \
	}\
	STATS.count++;\
}

#define INIT_STATS(STATS,NAME) {\
	(STATS).NAME.min = 1.0E32;\
	(STATS).NAME.max = -1.0E32;\
	(STATS).NAME.count = 0;\
	(STATS).NAME.sum = 0.0;\
	(STATS).NAME.sumsq = 0.0;\
	(STATS).NAME.title = #NAME;\
	(STATS).NAME.min_try = -1;\
	(STATS).NAME.min_trial = -1;\
	(STATS).NAME.max_try = -1;\
	(STATS).NAME.max_trial = -1;\
}

typedef struct sub_stats {
    double last_val;
    double sum;
    double sumsq;
    int    count;
    double min;
    int    min_try;
    int    min_trial;
    double max;
    int    max_try;
    int    max_trial;
    char   *title;
} sub_stats_t;

/* The following number is how many of the DCL_STATS will be averaged 
together */
#define NUMBER_OF_DCL_STATS 28

typedef struct stats {
    /* ************************************************************** */
    /* responsetime statistics. (total time to transfer page). ...... */
    /* ************************************************************** */
    /* code in webbot.c expects this to be the first statistic and    */
    /* for getpage_overhead to be the last statistic.  webbot.c also  */
    /* expects no other types to be interspersed between here and     */
    /* there. Violation of these rules will cause things too          */
    /* terrible to contemplate........................................*/
    /* ************************************************************** */
    /* ************************************************************** */
    /* firstdata response time statistics. (time from 1st connect     */
    /* try to first data received after all redirects have been       */
    /* followed) .................................................... */
    /* ************************************************************** */
    DCL_STATS(first_data_response_time)
    /* ************************************************************** */
    /* The end_to_end_time is the elapsed time, from the start of the */
    /* first request to the arrival of the last byte of the last gif. */
    /* The think_time is the actual measured pause after this request */
    /* The request time is end-to-end plus think-time.                */
    /* ************************************************************** */
    DCL_STATS(end_to_end_time)
    DCL_STATS(think_time)
    DCL_STATS(request_time)
    /* ************************************************************** */
    /* Response time statistics. (time from 1st connect try to all    */
    /* data received plus gifs....) After all redirects have been     */
    /* followed & if gifs are fetched. These times are collected as   */
    /* if the gifs were all fetched in serial order, and not in       */
    /* parallel via multithreading.  By contrast, the end_to_end time */
    /* is the parallel fetch time, so it will *always* be shorter     */
    /* than the response times.  .................................... */
    /* ************************************************************** */
    DCL_STATS(response_times)
    DCL_STATS(net_delay)
    DCL_STATS(ssl_ovhd)
    /* ************************************************************** */
    /* Html response time statistics. (time from 1st connect try to   */
    /* last hmtl received) (excludes gif xfer time). ................ */
    /* ************************************************************** */
    DCL_STATS(html_response_times)
    DCL_STATS(html_net_delay)
    DCL_STATS(html_ssl_ovhd)
    /* ************************************************************** */
    /* gif response time statistics (time spent getting gifs--summed  */
    /* over all gifs this page....................................... */
    /* ************************************************************** */
    DCL_STATS(gif_response_times)
    DCL_STATS(gif_net_delay)
    DCL_STATS(gif_ssl_ovhd)
    /* ************************************************************** */
    /* connecttime statistics. (time spent trying to connect --       */
    /* summed over all pages this req) ...............................*/
    /* ************************************************************** */
    DCL_STATS(connect_times)
    DCL_STATS(tcp_connect_times)
    DCL_STATS(ssl_connect_ovhd)
    DCL_STATS(ssl_net_delay_connect)
    /* ************************************************************** */
    /* headertime statistics. (time spent xferring header -- summed   */
    /* over all pages this req) (this is time from request sent to    */
    /* time header received) ........................................ */
    /* ************************************************************** */
    DCL_STATS(header_delays)
    DCL_STATS(ssl_header_ovhd)
    DCL_STATS(ssl_net_delay_header)
    /* ************************************************************** */
    /* transfer time statistics. (time spent transferring data) ..... */
    /*                           (summed over all pages this request).*/
    /* ************************************************************** */
    DCL_STATS(transfer_times)
    DCL_STATS(ssl_transfer_ovhd)
    DCL_STATS(ssl_net_delay_transfer)

    /* ************************************************************** */
    /* various internal measurements. ............................... */
    /* ************************************************************** */
    /* webboth.c assumes this is the FIRST internal statistic and is  */
    /* not printed unless tdebug is set.............................. */
    /* ************************************************************** */
    /* sum of get routine times for entire request. ................. */
    DCL_STATS(get_times)
    /* sum of get routine times for html files. (exclude gif files).  */
    DCL_STATS(html_get_times)
    /* sum of get routine times for gif  files. ..................... */
    DCL_STATS(gif_get_times)
    /* overhead times in the get subroutine. ........................ */
    DCL_STATS(get_overhead_times)
    DCL_STATS(html_ovhd_times)
    DCL_STATS(gif_ovhd_times)

    DCL_STATS(trial_duration)
    DCL_STATS(sum_of_think_times)
    DCL_STATS(sum_of_ovhd_times)
    /* ************************************************************** */
    /* measure of overhead time spent in getpage. ................... */
    /* webbot.c assumes this is the LAST statistics item in this      */
    /* structure. ................................................... */
    /* ************************************************************** */
    DCL_STATS(getpage_overhead)

    /* ************************************************************** */
    /* other misc statistics ........................................ */
    /* ************************************************************** */
    int        total_tries;           /* total number of tries this request. ............ */
    int        total_connects;        /* total number of connects summed over all trials. */
    int        total_redirects;       /* total number of redirects summed over all trials */
    int        total_reuses;          /* total number of reused conn's over all trials. . */
    int        total_refails;         /* total number of reused conn failures. .......... */
    int        total_num_gifs;        /* total number of gif files xferred. ............. */
    int        total_gif_hits;        /* total number of gif cache hits. ................ */
    int        max_connects;          /* max connect tries on any one request (this is    */
                                      /* at least one per redirect plus original requeest.*/

    request_size_t  total_setup;      /* setup = html on redirect pages ................. */
    request_size_t  total_lastpage;   /* lastpage = html (not gifs) on last page .........*/
    request_size_t  total_gif;        /* gif = gifs on last page ........................ */

} stats_t;

#endif /* !__WL_STATS_H__ */
