
/**************************************************************************
 *                                                                        *
 *               Copyright (C) 1995 Silicon Graphics, Inc.                *
 *                                                                        *
 *  These coded instructions, statements, and computer programs were      *
 *  developed by SGI for public use.  If any changes are made to this code*
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modifications and changes to the code and release it.                 *
 *                                                                        *
 **************************************************************************/

/* ========================== BEWARE ==================================== */
/* =================== HERE BE CONRAD VEIDT ============================= */
/* The code herein is a horrible, ugly hack of code that originally was
 * a part of SGI's WebStone.  It has spent a goodly portion of it's life
 * in the Laboratory of Dr. Frankenstein, who unmercifully sliced & diced
 * it the most unmentionable, despicable fashion.  In an attempt to remove
 * this code from its befouled birthing pen, management has given it to
 * me, Dr. Caligari.  My somnambulist has been doing well, as I have been
 * applying salves & ointments to heal its horrid wounds.  However, I
 * recognize my only mortal talents, and thus before your gaze rests
 * upon my Cesare,  be forewarned that your wits and faculties may 
 * be so repulsed by the sight that you may never recover status quo
 * ante bellum.  Five cents, please, and you may enter the tent.          */
/* ========================== BEWARE ==================================== */

#ifndef __WEBLOAD_GENERIC_H_
#define __WEBLOAD_GENERIC_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

#include "sysdep.h"
#include "timefunc.h"

/* Define to the version of the distribution.  */
#define RELEASE "WebLoad v4.1beta2"
#ifdef USE_SSLEAY
#define SSLVERSION "SSLeay"
#else
#ifdef USE_SKIT
#define SSLVERSION "SKITact3"
#else
#define SSLVERSION "noSSL"
#endif /* USE_SKIT */
#endif /* USE_SSLEAY */

#ifdef AIX
#define OSVERSION "AIX"
#endif

#ifdef WIN32
#define OSVERSION "Win32"
#endif

#ifndef OSVERSION 
#define OSVERSION "Linux"
#endif

#define VERSION RELEASE " (" OSVERSION " " SSLVERSION ")"


/* ================================================================== */
/* ================================================================== */
/* ================================================================== */
/* ================================================================== */

#define HTTP_STRING                  "http://"
#define HTTPS_STRING                 "https://"
#define META_STRING                  "<META"
#define HTTP_EQUIV_STRING            "HTTP-EQUIV"
#define REFRESH_STRING               "Refresh"
#define CONTENT_EQUAL_STRING         "Content="
#define SET_COOKIE                   "Set-cookie:"
#define COOKIE                       "Cookie: "
#define PATHSTR                      "path="


#define REQ_START         "============REQUEST SENT TO SERVER============\n"
#define BRWS_REQ_START    "==========REQUEST RECVD FROM BROWSER==========\n"
#define RSP_START         "==========RESPONSE RECVD FROM SERVER==========\n"
#define BRWS_RSP_START    "===========RESPONSE SENT TO BROWSER===========\n"
#define CHECK_SUM_HEADER  "=============CHECK SUM INFORMATION============\n"
#define CHECK_SUM_TRAILER "==============================================\n"
#define RSP_ERROR         "**** error occured while receiving response **\n"
#define EMPTY_RSP_MSG     "************ zero bytes received *************\n"
#define CHKSUMERRMSG      "************** check sum error ***************\n"
#define IMAGEDATASKIPPED  "********** binary data not printed ***********\n"
#define ERROR_END         "**********************************************\n"


/* ================================================================== */
/* ================================================================== */
/* ================================================================== */
/* ================================================================== */

#define MAXLINELENGTH 4096

#ifdef WIN32
extern int is_good_cpu (void);
#endif /* WIN32 */

#define UPPER(c) (((c) >= 'a' && (c) <= 'z') ? (c) + 'A' - 'a' : (c))

/* search for needle in haystack, from the back of the haystack.  */
/* this is a reversed version of strstr() */
extern char * rstrstr (const char *, const char *);

#ifdef WIN32
/* compare two strings with max length, ignoring case */
/* decalred here because some OS's  e.g. Win32/95/98/NT don't support it.  */
extern int strcasecmp(const char *str1, const char *str2);
extern int strncasecmp(const char *str1, const char *str2, size_t len);
extern char *stpcpy (char *dest, const char *src);
extern char *stpncpy (char *dest, const char *src, size_t len);
#endif /* WIN32 */

/* search for str2 in first nchar chars of str1, ignore case.. */
/* return pointer to first match, or null. ................... */
/* these are just like that strnstr and the strstr functions, except 
 * that they ignore the case. */
extern char *strncasestr(const char *str1, const char *str2, size_t len);
extern char *strcasestr(const char *str1, const char *str2);

#ifdef AIX
/* AIX doesn't support these string funcs */
extern int strncasecmp(const char *str1, const char *str2, size_t len);
extern char *stpcpy (char *dest, const char *src);
extern char *stpncpy (char *dest, const char *src, size_t len);
#endif /* AIX */

/* The strpskip() function locates the first occurrence in the
 * string s that does not match any of the characters in "reject".
 * This acts as the opposite of strpbrk()
 *
 * another possibly better implementation is this:
 * #define strpskip(s,r) (s+strspn(s,r))
 */
extern char * strpskip (const char * s, const char *reject);

extern int substitute (const char *string, const char *change_from, 
                       const char *change_to, char *result); 

/* ================================================================== */
/* ================================================================== */
/* ================================================================== */
/* ================================================================== */

#define FEQ(x,y) ((0.5e-6 > ((x)-(y)))  && (0.5e-6 > ((y)-(x)))) 

extern FILE *report_file;  /* needed by the prt() routine */
extern int quiet_stdout;
extern void plck (int);
extern int get_tid (void);
extern int prt(char * fmt, ...);
extern int perr(char * fmt, ...);
extern int pfatal(char * fmt, ...);

extern FILE   *error_log_file;
extern int     error_log;

/* print to error log file */
void errprt(char * fmt, ...);
void errlck (void);
void errunlck (void);
char * prettify (const char *);

#define PFATAL plck(2); pfatal("%d **************************************\n"	\
	"Fatal Error: %s: ", get_tid(), prettify(__FUNCTION__)); pfatal
#define PERR   plck(2); perr("%d Error: %s: ", get_tid(), prettify(__FUNCTION__)); perr
#define PWARN  plck(2); perr("%d Warning: %s: ", get_tid(), prettify(__FUNCTION__)); perr
#define PINFO  plck(2); prt ("%d Info: %s: ", get_tid(), prettify(__FUNCTION__)); prt
#define PDBG   if (debug) { plck(2); prt ("%d Debug: %s: ", get_tid(), prettify(__FUNCTION__)); } if (debug) prt
#define PDBG1  if (1<debug) { plck(2); prt ("%d Debug: %s: ", get_tid(), prettify(__FUNCTION__)); } if (1<debug) prt
#define PDBG2  if (2<debug) { plck (2); prt ("%d Debug: %s: ", get_tid(), prettify(__FUNCTION__)); } if (2<debug) prt


extern int   debug;
extern int   tdebug;


/* use the following names to print out timing debug info */
#define DT_PRINTF if (tdebug) prt
#define DT_PRINTF1 if (tdebug>1) prt

#ifdef OTHER_UNIX
#define DT_PP(NAME,TD) if (tdebug) prt("Time: %s %d:%d %f %s:%d\n",NAME,TD.tv_sec,TD.tv_usec,timevaldouble (&TD), __FILE__, __LINE__)
#define DT_PP1(NAME,TD) if (tdebug>1) prt("Time: %s %d:%d %f %s:%d\n",NAME,TD.tv_sec,TD.tv_usec,timevaldouble(&TD), __FILE__,__LINE__)
#endif /* OTHER_UNIX */

#ifdef AIX
#define DT_PP(NAME,TD) if (tdebug) prt("Time: %s %d:%d %f %s:%d\n",NAME,TD.tb_high,TD.tb_low,timevaldouble(&TD),__FILE__,__LINE__)
#define DT_PP1(NAME,TD) if (tdebug>1) prt("Time: %s %d:%d %f %s:%d\n",NAME,TD.tb_high,TD.tb_low,timevaldouble(&TD),__FILE__, __LINE__)
#endif /* AIX */

#ifdef WIN32
#define DT_PP(NAME,TD) if (tdebug) prt("Time: %s %d:%d %f %s:%d\n",NAME,TD.time,TD.millitm,timevaldouble (&TD), __FILE__, __LINE__)
#define DT_PP1(NAME,TD) if (tdebug>1) prt("Time: %s %d:%d %f %s:%d\n",NAME,TD.time,TD.millitm,timevaldouble(&TD), __FILE__, __LINE__)
#endif /* WIN32 */

#ifdef MICROSOFT_VISUAL_C
#define DT_PP(NAME,TD) if (tdebug) prt("Time: %s %d:%d %f\n",NAME,TD.HighPart,TD.LowPart,timevaldouble(&TD))
#define DT_PP1(NAME,TD) if (tdebug>1) prt("Time: %s %d:%d %f\n",NAME,TD.LowPart,TD.HighPart,timevaldouble(&TD))
#endif /* MICROSOFT_VISUAL_C */


/* ================================================================== */
/* ================================================================== */
/* ================================================================== */
/* ================================================================== */

#define MAX_ERROR_MESSAGE           -1
#define GET_CONNECT_ERROR           -2
#define GET_METHOD_ERROR            -3
#define GET_SEND_ERROR              -4
#define GET_READ_ERROR              -5
#define GET_HEADER2_ERROR           -6
#define GET_STATUS_ERROR            -7
#define GET_ALARM_CONNECT_ERROR     -8
#define GET_ALARM_ERROR             -9
#define GET_SSL_CONNECT_ERROR       -10
#define GET_NETCLOSE_ERROR          -11
#define GET_EINTR_ERROR             -12
#define GET_HEADER_TRIES_ERROR      -13
#define GET_SIGINT_ERROR            -14
#define GET_SIGHUP_ERROR            -15
#define GET_SIGFIN_ERROR            -16
#define GET_EOF_ERROR               -17
#define GET_THREAD_ERROR            -18
#define GET_URL_ERROR               -19
#define GET_LOCATION_ERROR          -20
#define GET_LOCATION_ERROR2         -21
#define GET_URL_LENGTH_ERROR        -22
#define GET_MISSING_COOKIE          -23
#define MIN_ERROR_MESSAGE           -24

#define ERROR_MESSAGE_ARRAY_SIZE        ((-(MIN_ERROR_MESSAGE))+1)

extern char  *webload_error_msg[ERROR_MESSAGE_ARRAY_SIZE];
extern void init_webload_errors (void);
extern char *webload_error (int error);

/* ================================================================== */
/* ================================================================== */
/* ================================================================== */
/* ================================================================== */

#ifdef WIN32
extern int	expire_alarm (int fd, int nsecs);
#endif
extern void signal_handler(int signal);

extern volatile int alarm_expired;
extern volatile int have_been_interrupted;
extern volatile int retry_io;
extern volatile int close_io;
extern volatile int caught_sigpipe;

#ifdef __cplusplus
};
#endif

/* ================================================================== */
/* ================================================================== */
/* ================================================================== */
/* ================================================================== */

#endif /* __WEBLOAD_GENERIC_H_ */
