#ifndef _WEBTREE_H
#define _WEBTREE_H

#include <qtimer.h>
#include <qmenubar.h>
#include <qtabdlg.h>
#include <qfont.h>
#include <qcolor.h>

#include <kapp.h>
#include <ktopwidget.h>
#include <ktoolbar.h>
#include <kmsgbox.h>
#include <ksimpleconfig.h>
#include <ktreelist.h>
#include "view/kpanner.h"
#include "view/animw.h"

#include "version.h"

extern "C" 
{
#include "document.h"
};

/* forward declarations */

class Viewport;
class WtView;
class WtViewWin;
class TreeList;

/* Resource definitions */

#define ID_FILE_NEW		1
#define ID_FILE_OPEN		2
#define ID_FILE_SAVE		3
#define ID_FILE_SAVE_AS		4
#define ID_FILE_CLOSE		5
#define ID_FILE_QUIT		6

#define ID_OPTIONS_PREFS	10
#define ID_OPTIONS_DEFAULTPREFS	11
#define ID_OPTIONS_APPEARANCE	12
#define ID_OPTIONS_SAVE_WINPOS	13

#define ID_HELP_ABOUT		80
#define ID_HELP_CONTENTS	81

#define ID_STOP			200
#define ID_PAUSE		201
#define ID_CONT			202

#define ID_TOGGLE_MLINKS	205

#define ID_VIEW_CENTER		100
#define ID_VIEW_TOPDOWN		101
#define ID_VIEW_LEFTRIGHT	102
#define ID_VIEW_TREELIST	103

#define ID_STAT_THREADS		300
#define ID_STAT_POSTPONED	301
#define ID_STAT_URL		302
#define ID_STAT_TEXT		303

#define ID_LOCATION_LINED       400
#define ID_ZOOM_FRAME           401
#define ID_LOCATION_FRAME       402
#define ID_LOCATION_ANIM        404

/* id's for popup menu */
#define ID_STOP_NODE	10
#define ID_START_NODE	11
#define ID_INFO		12
#define ID_PREVIEW	13
#define ID_SAVE_PAGE	14
#define ID_NEW_LOCATION 15
#define ID_COLLAPSE_NODE 16
#define ID_EXPAND_NODE  17
#define ID_POP_CHILD    18
#define ID_POP_FATHER   19

/* end Resource def */

struct Appearance
{
  QColor back;		/* window background */
  QColor text;		/* text		     */
  QColor line;		/* line color        */

  QColor html;		/* color for html docs		*/
  QColor graphic;	/* color for pictures		*/
  QColor packed;	/* color for packed files	*/
  QColor ordered;	/* color for ordered Document	*/
  QColor error;		/* color for documents not found*/
  QColor other;		/* color for the rest		*/
  QColor collapsed;     /* color for the collapsed frame */

  bool mouseLinks;	/* show links only when mouse cursor over node */
  bool lens_effect;     /* draw everything with a lens effect */
  double lens_exp;      /* lens exponent: something between 1 and 5, 1 is normal, 5 is .. uhm. heavy  */
  bool drag_method1;    /* window content dragging method */

  /* TODO: the following is obsolete (hopefully) kill it */
  bool pixmapRedraw;	/* redraw into pixmap (avoids flickering) (TODO:implment it)*/

  QFont font;		/* Font to use for links */

  int fontminsize;	/* minimum Fontsize */
  int fontmaxsize;	/* maximum Fontsize */

  int x, y, width, height;        /* window position */

  /* these are not saved -> computed on the fly */

  QColorGroup *cg_html, *cg_graphic, *cg_packed, *cg_ordered, *cg_error, *cg_other;
  QBrush *br_html, *br_graphic, *br_packed, *br_ordered, *br_error, *br_other;
};

extern Appearance appear;
extern QPixmap *loadAnim[LOAD_ANIM_FRAMES], *noLoadAnim, *treeHtmlDoc, *treePicDoc,
  *treeCompDoc, *treeOtherDoc, *aboutPixmap, *dndPixmap;
extern QString kdndHtmlPix, tempFile;

/* The Top Level Widget */

class WebTree : public KTopLevelWidget
{
  Q_OBJECT;
  
public:
  WebTree( Pref *copyPrefs, QWidget *parent = 0, char *name = 0 );
  ~WebTree();
  
  static QList<WebTree> windowList;
  
  /* for reading the default preferences & appearance prefs */
  /* also used for storing queries */
  static void readAppPrefs();
  static void writeAppPrefs();
  static void readPrefs(KConfigBase *, Pref *);
  static void writePrefs(KConfigBase *, Pref *);
  static void readAppear(KConfigBase *, Appearance *);
  static void writeAppear(KConfigBase *, Appearance *);
  static void initAppear( Appearance *a );
  static void endAppear( Appearance *a );
  static void recomputeAppear( Appearance *a );
  static WebTree* newWindow( bool first = FALSE, Pref *copyPrefs = NULL );

  /* menu/toolbar connections */
  void openFile();			/* open a query */
  void saveFile(bool saveAs = FALSE);	/* save a query */
  void quit();				/* quit application */
  void preferences(Pref *);		/* show the preferences */
  void aboutBox();			/* show the about dialog */
  void setAppearance();			/* set appearence (color fonts ...) */
  void stopLoading();			/* halt the loading process */
  void pauseLoading( bool cont );	/* pause the loading process */

  /* other public methods */
  void loadFile(const QString &f);
  void saveWindowPos();
  void updateView( bool updov = TRUE );
  void updateAllViews( bool updov = TRUE );
  void setLayoutSpace(int width, int height);
  void nodeAdded(TreeInfo *);

  bool isChanged() { return changed; }
  bool isEmpty() { return empty; }
  Document* document() { return &doc; }
  
  public slots:
    void itemSelected(int);	/* for menu/toolbar */
  void changeStatusUrl(const char *);
  void changeStatusText(const char *);
  void startLoading(const char *loc);
/*  void startLoadingNode(TreeInfo *);
  void stopLoadingNode(TreeInfo *);*/
  void savePage(TreeInfo *);
  void updateWebTree();
  void dropEvent(KDNDDropZone *);
  void updateViewType();
  void resizeViews();
  void updateThreadsPostponed();
  void resizePanner();
  void processWebTree();
  void ensureLoading();
  void savePageArrived( const char *, char *);
  void urlChanged();  
  void zoomChanged(int);

private:
  KToolBar *toolbar1, *toolbar2, *locbar;
  QLabel* zoomlabel;
  KStatusBar *statusbar;
  KMenuBar *menubar;
  AnimW* loadAnimW;

  Viewport *viewport;
  WtViewWin *viewwin, *overviewwin;
  KPanner *panner;
  WtView *view, *overview;
  TreeList *treelist;
  KDNDDropZone *dropzone;	/* for dnd */

  QTimer *timer, *snappy;	/* this is the timer for updating */

  bool changed;		/* changed ? */
  bool empty;		/* newly created ? */
  Document doc;		/* all document data */

  QString filename;
  QString location;
  
  void createToolbar();
  void createMenubar();
  void createStatusbar();

protected:
  void closeEvent(QCloseEvent *e);

signals:
  void animationStep();
  void setLocation(const char *);
  void resetViewWin();
};

#endif












