#ifndef _WTVIEW_H
#define _WTVIEW_H

#include <kpopmenu.h>
#include <qlist.h>
#include <qwidget.h>
#include <qdrawutl.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qscrbar.h>
#include <qarray.h>

#include "../dlg/dlg_info.h"
#include <drag.h>

/* struct TreeInfo; */
extern "C"
{
#include "../html/html.h"
}

struct Document;
class WtViewWin;
class WtTip;

/* This class holds the WebTree View + the two scrollbars */
class WtView : public QWidget
{
  Q_OBJECT;

public:
  WtView(Document *d, QWidget *parent = 0, const char *name = 0, bool over = FALSE );
  virtual ~WtView();

  WtViewWin* getViewWin() { return viewwin; }

  public slots:
    void resizeScrollBars();

protected:
  void resizeEvent(QResizeEvent *);

private:
  WtViewWin *viewwin;
  QScrollBar *hscroll, *vscroll;
  bool isOverview;

  friend class WtViewWin;
};


/* This is the webtree-view */
class WtViewWin : public KDNDWidget
{
  Q_OBJECT;

public:
  WtViewWin( Document *d, QWidget *parent = 0, const char *name = 0, bool over = FALSE );
  virtual ~WtViewWin();

  void getSizeForText( int *width, int *height, char *text, int fontsize );
  
  void myUpdate( int x = 0, int y = 0, int w = 0, int h = 0 );
  void overviewCheckSize();

protected:
  void resizeEvent( QResizeEvent * );
  void paintEvent( QPaintEvent * );
  void mouseMoveEvent( QMouseEvent * );
  void mousePressEvent( QMouseEvent * );
  void mouseReleaseEvent( QMouseEvent * );
  void leaveEvent( QEvent * );
  /* for drag and drop */
  void dndMouseReleaseEvent( QMouseEvent * );
  void dndMouseMoveEvent( QMouseEvent * );


  public slots:
    void popupSelected( int );
  void childPopupSelected( int );
  void fatherPopupSelected( int );
  void zoomChanged( int );
  void setSize( int, int );
  void scrollHorizTo( int );
  void scrollVertTo( int );
  void centerTreeInfo( TreeInfo * );
  void picEnsureLoading();
  void resetViewWin();

private:
  TreeInfo* treeInfoUnder( const QPoint& );
  int lensTransform( int, int, double );
  void info( TreeInfo * );
  void dragContent();
  void drawLinksFor( TreeInfo *, QPainter *, int ox = 0, int oy = 0);
  void fillPopupMenus();
  QRect calcCliprectForLinks( TreeInfo * );


  bool isOverview;              /* indicates if this view is an Overview */

  Document *doc;
  KPopupMenu *popup;
  QPopupMenu *pop_child, *pop_father;

  QList<DlgInfo> infoList;

  QArray<TreeInfo*> pop_child_arr, pop_father_arr;

  /* there could be problems with large values on machines */
  /* with int = short ? */
  int offset_x, offset_y;	/* offset to viewwindow, always positive*/
  int size_w, size_h,		/* size of layoutspace & scaled to zoomfactor size*/
    realSize_w, realSize_h;
  int zoom;			/* zoomfactor */
  
  bool stickmlinks;
  bool draggingEnabled;		/* true if in middle of window-content-drag */
  bool signal_choke;		/* needed to avoid multiple reoaints */
  bool pixBuffer;		/* draw first into pixmap (to avoid flickering) ? */
				/* or draw directly into screen (not yet implemented) */
  TreeInfo *last_ti;		/* last treeinfo over which the mouse was */
  TreeInfo *selected_ti;        /* selected treeinfo if view is overview */

  bool pressed;		/* indicated if mbutton si pressed*/
  int press_x, press_y; /* last mouse coordinates */
  TreeInfo *dragUrl;

  WtTip *tooltip;

  friend class WtView;
  friend class WtTip;

signals:
  void setLocation( const char * );
/*  void startLoadingNode( TreeInfo * );
  void stopLoadingNode( TreeInfo * );*/
  void savePage( TreeInfo * );
  void setStatusUrl( const char * );
  void treeInfoSelected( TreeInfo * );
  void ensureLoading();
};

#endif








