#include "wtview.h"
#include "stdlib.h"
#include <stdarg.h> 
#include "../webtree.h"

void view_setStatusLine(char *text)
{
  WebTree *wt;
  if(::context == NULL)
    debug("context not set");
  else
  {
    wt = (WebTree*)(context->view.window);
    wt->changeStatusText(text);
  }
}


void view_setLayoutSpace(int width, int height)
{
  WebTree *wt;
  if(::context == NULL)
    debug("context not set");
  else
  {
    wt = (WebTree*)(context->view.window);
    wt->setLayoutSpace(width, height);
  }
}

void view_htmlFinished()
{
  WebTree *wt;
  if(::context == NULL)
    debug("context not set");
  else
  {
    wt = (WebTree*)(context->view.window);
    wt->stopLoading();
  }
}

void view_getFontSizes( int *sizemax, int *sizemin )
{
  *sizemax = ::appear.fontmaxsize;
  *sizemin = ::appear.fontminsize;
}

void view_getSizeForText(int *width, int *height, char *text, int fontsize)
{
  WtViewWin *v;
  if(::context == NULL)
    debug("context not set");
  else
  {
    v = (WtViewWin*)(context->view.view);
    v->getSizeForText(width, height, text, fontsize);
  }
}

void view_update(int , int , int , int )
{
  WebTree *wt;
  wt = (WebTree*)(context->view.window);
  wt->updateView();
}

void view_nodeAdded(TreeInfo* ti)
{
  ( (WebTree*)(context->view.window) )->nodeAdded(ti);
}

void view_pageLoaded( int status, int size, char *text, void *data )
{
  GurlStruct *g = (GurlStruct*)data;
  WebTree *wt;
  
  if( status != -23 ) /* aborted */
  {
  
    if( status == 200 )
    {
      
      dbg( DI, DBG_VIEW | 3, "page loaded" );
    
      switch( g->type )
      {
	case GURL_SAVEPAGE:
	  wt = ( WebTree* )( (Document*)g->doc )->view.window;
	  wt->savePageArrived( ( const char * )g->fn, text );
	  break;
      }
    }
    else
    {
      dbg( DI, DBG_VIEW | 1, "error while retrieving page... blabla" );
    }

    if( size > 0)
      free( text );
  }
  else
    dbg( DI, DBG_VIEW | 1, "loading of page aborted" );

  free( g );
}

void view_orderPage( char *url, int typ, void *d, void *t, char *fname, void *p )
{
  ::context = (Document *)d;
  GurlStruct *g = (GurlStruct*)malloc( sizeof( GurlStruct ) );
  g->type = typ;
  g->doc = d;
  g->treeinfo = t;
  if( fname )  strcpy( g->fn, fname);
  else         g->fn[0] = '\0';
  g->prev = p;
  strcpy( g->url, url );
  dbg( DI, DBG_VIEW | 3, "order page: %s", url );
  html_getUrl( url, &view_pageLoaded, g);
}

void dbg( int l,  char *fn, char *m, int dblvl, char *msg, ...)
{
  if( (dblvl & 3) <= (debug_level & 3) &&
      ((dblvl & 124) & (debug_level & 124)) )
  {
    va_list pa;
    va_start( pa, msg );
    fprintf( stderr, "%s:%d:(%s) - ", m, l, fn );
    vfprintf( stderr, msg, pa );
    fprintf( stderr, "\n" );
    va_end( pa );
  }
}









