#ifndef _VIEW_H
#define _VIEW_H

#define VIEW_BORDER 3		/* offset around widgets in location bar */
#define VIEW_THEIGHT 30		/* Height of Location bar */
#define BORDER_WIDTH 4		/* border width of Treeinfo Boxes */

#define LOAD_ANIM_FRAMES 4	/* Frames of animation */
#define ANIM_WIDTH 22		/* Animation width */
#define ANIM_HEIGHT 22		/* Animation height */
#define SC_WIDTH 16	        /* Scrollbar width for Viewport */

#define ARROW_WIDTH 3		/* width of arrow */
#define ARROW_HEIGHT 8		/* height of arrow */

struct View
{
  void *window;		/* Pointer to the window object (WebTree * in Qt) */
  void *view;		/* Pointer to the wtviewwin */
};

// internal

#define GURL_SAVEPAGE 1
#define GURL_PREVIEW  2
#define GURL_IMAGE    3

struct GurlStruct
{
  int type;
  void *doc;
  void *treeinfo;
  char fn[300];
  char url[500];
  void *prev;
};

extern int debug_level;

/* some helper functions */

/* set text in statusline of topwidget */
extern void view_setStatusLine(char *text);	
/* set width & height of needed space to draw webtree */
extern void view_setLayoutSpace(int width, int height);
/* called by html-module when ready */
extern void view_htmlFinished();
/* calculates size of rect surrounding text with fontsize fontsize*/
extern void view_getSizeForText(int *width, int *height, char *text, int fontsize);
/* update view */
extern void view_update(int x, int y, int width, int height);
/* add node (used by tree list) */
extern void view_nodeAdded(struct TreeInfo *ti);
/* get font sizes */
extern void view_getFontSizes( int *sizemax, int *sizemin );
/* callbacks for html */
extern void view_pageLoaded( int status, int size, char *text, void *data );
/* internal */
extern void view_orderPage( char *url, int typ, void *d, void *t, char *fname, void *p );


/* debug routine  */
extern void dbg( int l,  char *fn, char *m, int dblvl, char *msg, ...);


#endif




